import html from "../../services/html.js";
import { pillStyles } from "./eden-edit-structure-entry.styles.js";
import t from "../../i18n/index.js";
export default function template({ langs, lang, templates, metadata, isSuperAdmin, }) {
    const metadataButton = metadata
        ? html `<button
        type="button"
        class="edit-structure-entry__tab edit-structure-entry__tab--metadata"
      >
        ${t("structure.page.advanced")}
      </button>`
        : "";
    return html `
    <form class="edit-structure-entry">
      <div class="edit-structure-entry__top">
        <div class="edit-structure-entry__tabs">
          <button type="button" class="edit-structure-entry__tab edit-structure-entry__tab--menu edit-structure-entry__tab--active">${t("structure.menu.tab")}</button>
          <button type="button" class="edit-structure-entry__tab edit-structure-entry__tab--page">${t("structure.page.tab")}</button>
          <button type="button" class="edit-structure-entry__tab edit-structure-entry__tab--seo" >${t("structure.seo.tab")} <span class="edit-structure-entry__pill edit-structure-entry__pill--tab"></span></button>
          ${metadataButton}
        </div>
        <div class="edit-structure-entry__lang-switch">
          ${renderLang(langs, lang)}
        </div>
      </div>
      <div class="edit-structure-entry__forms">
        <div class="edit-structure-entry__form edit-structure-entry__form--menu edit-structure-entry__form--visible">
          <eden-input type="text" label="${t("structure.menu.title")}" name="label"></eden-input>
          <eden-input type="text" label="${t("structure.menu.subtitle")}" name="subTitle"></eden-input>
          <eden-input type="text" label="${t("structure.menu.short-title")}" name="shortLabel"></eden-input>
          <div class="edit-structure-entry__wrapper">
            <eden-input type="text" label="${t("structure.menu.url")}" name="url" spellcheck="false"></eden-input>
            <button type="button" is="eden-button" class="edit-structure-entry__action edit-structure-entry__action--copy-url" tooltip="${t("structure.copy-url")}">
              <eden-icon code="copy"></eden-icon>
            </button>
          </div>
          <div class="edit-structure-entry__group">
            <div>
              <eden-checkbox label="${t("structure.menu.disabled")}" name="disabled"></eden-checkbox>
            </div>
            <button type="button" is="eden-button" class="edit-structure-entry__helper" tooltip="${t("structure.menu.disabled-helper")}">
              <eden-icon code="information" class="edit-structure-entry__helper-icon"></eden-icon>
            </button>
          </div>
        </div>
        <div class="edit-structure-entry__form edit-structure-entry__form--page">
          <eden-input type="select" label="${t("structure.page.template")}" name="page-template">
            <option value="">${t("common.none")}</option>
            ${renderTemplates(templates)}
          </eden-input>
          <eden-checkbox label="${t("structure.page.accessible")}" name="visible""></eden-checkbox>
          <eden-checkbox label="${t("structure.page.highlight")}" name="highlight""></eden-checkbox>
        </div>
        <div class="edit-structure-entry__form edit-structure-entry__form--seo">
          <eden-input type="text" label="${t("structure.seo.title")}" name="title" pill="edit-structure-entry__pill edit-structure-entry__pill--title">${pillStyles}</eden-input>
          <eden-input type="text" label="${t("structure.seo.keywords")}" name="keywords"></eden-input>
          <eden-input type="textarea" label="${t("structure.seo.description")}" name="description" pill="edit-structure-entry__pill edit-structure-entry__pill--description">${pillStyles}</eden-input>
          <div class="edit-structure-entry__description-count-container">
            <span class="edit-structure-entry__description-count"></span> /
            <span class="edit-structure-entry__description-count-max"></span>
          </div>
          <eden-input type="select" label="${t("structure.seo.robots")}" name="robots" ${!isSuperAdmin ? "hidden" : ""}>
            <option value=""></option>
            <option value="index">index</option>
            <option value="index, follow">index, follow</option>
            <option value="index, nofollow">index, nofollow</option>
            <option value="noindex">noindex</option>
            <option value="noindex, follow">noindex, follow</option>
            <option value="noindex, nofollow">noindex, nofollow</option>
          </eden-input>
          <eden-input type="text" label="${t("structure.seo.canonical")}" name="canonical" ${!isSuperAdmin ? "hidden" : ""}></eden-input>
          <div class="edit-structure-entry__sitemap" ${!isSuperAdmin ? "hidden" : ""}>
            <div class="edit-structure-entry__sitemap-label">${t("structure.seo.sitemap-config")}</div>
            <eden-checkbox label="${t("structure.seo.sitemap-include")}" name="included""></eden-checkbox>
            <eden-input type="select" label="${t("structure.seo.sitemap-frequency")}" name="frequency">
              <option value="Always" selected="">Always</option>
              <option value="Hourly">Hourly</option>
              <option value="Daily">Daily</option>
              <option value="Weekly">Weekly</option>
              <option value="Monthly">Monthly</option>
              <option value="Yearly">Yearly</option>
              <option value="Never">Never</option>
            </eden-input>
            <eden-input type="select" label="${t("structure.seo.sitemap-priority")}" name="priority">
              <option value="0.1">0.1</option>
              <option value="0.2">0.2</option>
              <option value="0.3">0.3</option>
              <option value="0.4">0.4</option>
              <option value="0.5">0.5</option>
              <option value="0.6">0.6</option>
              <option value="0.7">0.7</option>
              <option value="0.8">0.8</option>
              <option value="0.9">0.9</option>
            </eden-input>
          </div>
        </div>
        <div class="edit-structure-entry__form edit-structure-entry__form--metadata">
          ${renderMetadata(metadata)}
        </div>
      </div>
      <div class="edit-structure-entry__buttons">
        <button type="submit" class="edit-structure-entry__button edit-structure-entry__button--confirm">
          ${t("common.save")}
          <eden-icon code="enter_key" class="edit-structure-entry__button-icon"></eden-icon>
        </button>
      </div>
    </form>
    `;
}
function renderLang(langs, currentLang) {
    return langs
        .map((lang) => {
        const classes = lang === currentLang
            ? `edit-structure-entry__lang edit-structure-entry__lang--active`
            : "edit-structure-entry__lang";
        return html `<button type="button" class="${classes}">${lang}</button> `;
    })
        .join("");
}
function renderTemplates(templates) {
    return templates
        .map((template) => {
        const view = template.view === "/index" ? "/" : template.view;
        return html `<option value=${view}>${template.name}</option> `;
    })
        .join("");
}
function renderMetaDataOptions(options) {
    if (!options)
        return "";
    return options
        .map((option) => html `<option value="${option}">${option}</option>`)
        .join("");
}
function renderMetadata(metadata = []) {
    return metadata
        .map((data) => {
        const { code, label, type, options, allowMultipleOptions, helper } = data;
        if (type === "checkbox") {
            return html `<eden-checkbox
          label="${label}"
          name="${code}"
        ></eden-checkbox>`;
        }
        const helperAttribute = helper ? `helper="${helper}"` : "";
        if (type === "text" && options && options?.length > 0) {
            const multiple = allowMultipleOptions ? "multiple" : "";
            const formatedOptions = options.join(",");
            return html `<eden-tag-manager
          ${multiple}
          name="${code}"
          label="${label}"
          options="${formatedOptions}"
          ${helperAttribute}
        ></eden-tag-manager>`;
        }
        return html `
        <eden-input
          type="${type}"
          label="${label}"
          name="${code}"
          ${helperAttribute}
        >
          ${renderMetaDataOptions(options)}
        </eden-input>
      `;
    })
        .join("");
}
