import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
const confirm = ".modal__button--confirm";
const disabled = "modal__button--disabled";
const error = ".modal__error";
const visible = "modal__error--visible";
const TYPES = [
    "track",
    "playlist",
    "album",
    "artist",
    "concert",
    "show",
    "episode",
];
export default class SpotifyModal {
    constructor(onChange, uri, width, height) {
        this.checkUri = () => {
            const root = this.modal.shadowRoot;
            const input = root.querySelector("[name=uri]");
            const uri = input.value;
            const splittedUri = uri.split(":");
            const valid = splittedUri[0] === "spotify" && TYPES.includes(splittedUri[1]);
            if (valid) {
                root.querySelector(confirm).classList.remove(disabled);
                root.querySelector(error).classList.remove(visible);
            }
            else {
                root.querySelector(confirm).classList.add(disabled);
                root.querySelector(error).classList.add(visible);
            }
        };
        this.onClick = () => {
            const root = this.modal.shadowRoot;
            const uriInput = root.querySelector("[name=uri]");
            const widthInput = root.querySelector("[name=width]");
            const heightInput = root.querySelector("[name=height]");
            const uri = uriInput.getAttribute("value");
            const width = widthInput.getAttribute("value");
            const height = heightInput.getAttribute("value");
            this.onChange(uri, width, height);
        };
        this.onChange = onChange;
        this.modal = new EdenModal({
            icon: "spotify",
            title: t("modals.spotify.title"),
            content: template(uri, width, height),
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                { value: t("common.add"), onClick: this.onClick, cssClass: "confirm" },
            ],
        });
        document.body.append(this.modal);
        const root = this.modal.shadowRoot;
        root.querySelector("[name=uri]").addEventListener("input", this.checkUri);
    }
}
function template(uri, width, height) {
    return html `
    <style>
      .modal__form {
        width: 450px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
        padding: 10px 0;
        box-sizing: border-box;
      }

      .modal__error {
        margin: -10px 0 10px 0;
        padding-top: 3px;
        color: var(--eden-red-400);
        font-size: 12px;
        opacity: 0;
        pointer-events: none;
      }

      .modal__error--visible {
        opacity: 1;
      }

      .modal__information {
        font-size: 13px;
        padding: 5px 0;
        color: var(--eden-grey-500);
      }

      .modal__helper {
        padding: 5px 0;
        font-size: 12px;
        font-style: italic;
      }
    </style>
    <div class="modal__form">
      <eden-input
        type="text"
        label="${t("modals.spotify.width")}"
        name="width"
        value="${width || 300}"
      ></eden-input>
      <eden-input
        type="text"
        label="${t("modals.spotify.height")}"
        name="height"
        value="${height || 380}"
      ></eden-input>
      <eden-input
        type="text"
        label="${t("modals.spotify.uri")}"
        name="uri"
        value="${uri || ""}"
      ></eden-input>
      <div class="modal__error">
        ${t("modals.spotify.invalid-format")} <b><i>spotify:xxx:xxx</i></b>
      </div>
      <div class="modal__information">
        ${t("modals.spotify.copy-code")}<br />
      </div>
      <div class="modal__helper">
        ${t("modals.spotify.helper-login")}<br />
        ${t("modals.spotify.helper-navigate")}<br />
        ${t("modals.spotify.helper-share")} <b>"${t("modals.spotify.helper-share-button")}"</b> ${t("modals.spotify.helper-dropdown")} "<b>${t("modals.spotify.share-label")}</b>", ${t("modals.spotify.helper-alt-key")} "<b>${t("modals.spotify.helper-copy-uri")}</b>".<br />
        ${t("modals.spotify.helper-paste")}
      </div>
    </div>
  `;
}
