import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
const ACE_EDITOR_ID = "ace-editor";
export default class SourceModal {
    constructor(onChange, html) {
        this.init = async () => {
            this.modal = new EdenModal({
                icon: "source",
                title: t("modals.source.title"),
                width: 750,
                height: 420,
                content: template(),
                noPadding: true,
                buttons: [
                    { value: t("common.cancel"), cssClass: "cancel" },
                    { value: t("common.save"), onClick: this.onClick, cssClass: "confirm" },
                ],
            });
            document.body.append(this.modal);
            this.root = this.modal.shadowRoot;
            await loadAce();
            window.ace.config.set("basePath", "https://cdn.jsdelivr.net/npm/ace-builds@1.43.4/src-noconflict");
            this.editor = window.ace.edit(this.root.querySelector("#html"));
            this.editor.renderer.attachToShadowRoot();
            this.editor.setOptions({ fontSize: 14 });
            this.editor.getSession().setUseWorker(false);
            this.editor.session.setMode("ace/mode/html");
            this.editor.session.setTabSize(2);
            this.editor.setTheme("ace/theme/github_dark");
            this.editor.setValue(this.html || "");
        };
        this.onClick = () => {
            const html = this.editor.getValue();
            this.onChange(html);
        };
        this.onChange = onChange;
        this.html = html;
    }
}
async function loadAce() {
    return new Promise((resolve) => document.getElementById(ACE_EDITOR_ID) !== null
        ? resolve("error")
        : document.body.appendChild(Object.assign(document.createElement("script"), {
            src: "https://cdn.jsdelivr.net/npm/ace-builds@1.43.4/src-noconflict/ace.min.js",
            id: ACE_EDITOR_ID,
            onload: resolve,
        })));
}
function template() {
    return html ` <style>
      .modal__editor {
        position: relative;
        width: 100%;
        min-width: 50vw;
        max-width: 100%;
        min-height: 350px;
        max-height: 90vh;
      }

      .ace_editor,
      .ace_editor * {
        font-family: var(--eden-content-font);
        font-size: 14px;
      }
    </style>
    <div id="html" class="modal__editor"></div>`;
}
