import EdenModal from "../common/eden-modal.js";
import type { Attribute, Variant } from "../../types.js";
interface Settings {
    id: string;
    tags: string;
    hidden: boolean;
    variant?: string;
    tagsLabel?: string;
    allowedTags?: string;
    allowMultipleTags?: boolean;
    attributes?: Record<string, Attribute>;
}
interface OnChangeParams {
    variant: string;
    id: string;
    tags: string;
    hidden: boolean;
    attributes: {
        property: string;
        value: string;
    }[];
}
type OnChange = (params: OnChangeParams) => void;
export default class SettingsModal {
    onChange: OnChange;
    variants?: Variant[];
    defaultVariantName?: string;
    values: Settings;
    modal: EdenModal;
    root: ShadowRoot;
    constructor(onChange: OnChange, values: Settings, variants?: Variant[], defaultVariantName?: string);
    init(): void;
    checkId: () => void;
    updateSettings: () => void;
}
export {};
//# sourceMappingURL=settings-modal.d.ts.map