import EdenModal from "../common/eden-modal.js";
import EdenDatesSelector from "../block/eden-dates-selector.js";
import t from "../../i18n/index.js";
export default class SelectDatesModal {
    constructor(changeSelection, copiedDates, selectedDates) {
        this.updateDates = () => {
            this.changeSelection(this.datesSelector.getDates());
        };
        this.pasteDates = () => {
            if (!this.copiedDates)
                return;
            this.datesSelector.updateDates(this.copiedDates);
        };
        this.changeSelection = changeSelection;
        this.selectedDates = JSON.parse(selectedDates || "[]");
        this.copiedDates = copiedDates ? JSON.parse(copiedDates) : null;
        this.datesSelector = new EdenDatesSelector(this.selectedDates);
    }
    init() {
        const baseButtons = [
            { value: t("common.cancel"), cssClass: "cancel" },
            {
                value: t("common.apply"),
                onClick: this.updateDates,
                cssClass: "confirm",
            },
        ];
        const buttons = this.copiedDates
            ? [
                {
                    value: t("modals.select-dates.paste-dates"),
                    cssClass: "option",
                    onClick: this.pasteDates,
                    keepOpened: true,
                },
                ...baseButtons,
            ]
            : baseButtons;
        this.modal = new EdenModal({
            icon: "calendar",
            width: 620,
            title: t("modals.select-dates.title"),
            content: this.datesSelector,
            buttons,
        });
        document.body.append(this.modal);
    }
}
