import type { PictureOptions } from "../../types.js";
interface Result {
    key: string;
    src: string;
    width: string;
    height: string;
    metadata: string;
}
type OnChange = (result: Result[]) => void;
export default class MultipleSizedImagesModal {
    element: HTMLElement;
    markup?: string;
    onChange: OnChange;
    sizes: PictureOptions["sizes"];
    modal: any;
    root: ShadowRoot;
    imagesElements: HTMLImageElement[];
    results: Result[];
    constructor(element: HTMLElement, onChange: OnChange, sizes: PictureOptions["sizes"], markup?: string);
    init(): void;
    initImages: () => void;
    updateImages: () => void;
    closeModal: () => void;
    onClick: (e: Event) => Promise<void>;
    onConfirm: () => void;
}
export {};
//# sourceMappingURL=multiple-sized-images-modal.d.ts.map