import EdenModal from "../common/eden-modal.js";
import html from "../../services/html.js";
import t from "../../i18n/index.js";
export default class LinkModal {
    constructor(onChange, url, title, target) {
        this.onClick = () => {
            const root = this.modal.shadowRoot;
            const urlInput = root.querySelector("[name=url]");
            const url = urlInput.value;
            const titleInput = root.querySelector("[name=title]");
            const title = titleInput.value;
            const targetCheckbox = root.querySelector("[name=target]");
            const target = targetCheckbox.checked;
            this.onChange(url, title, target);
        };
        this.closeModal = () => {
            const root = this.modal.shadowRoot;
            const linkPickerButton = root.querySelector("#link-picker");
            linkPickerButton.removeEventListener("click", this.openLinkPicker);
        };
        this.getPath = (path) => {
            const root = this.modal.shadowRoot;
            const urlInput = root.querySelector("[name=url]");
            urlInput.setAttribute("value", path);
        };
        this.openLinkPicker = async () => {
            const { default: LinkFromStructureModal } = await import("./link-from-structure-modal.js");
            new LinkFromStructureModal({
                onChange: (p) => this.getPath(p),
            }).init();
        };
        this.onChange = onChange;
        this.url = url;
        this.title = title;
        this.target = target;
    }
    init() {
        this.modal = new EdenModal({
            icon: "link",
            title: t("modals.link.title"),
            content: template(this.url, this.title, this.target),
            onClose: this.closeModal,
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                {
                    value: t("common.insert"),
                    onClick: this.onClick,
                    cssClass: "confirm",
                },
            ],
        });
        const root = this.modal.shadowRoot;
        document.body.append(this.modal);
        const linkPickerButton = root.querySelector("#link-picker");
        linkPickerButton.addEventListener("click", this.openLinkPicker);
        const urlInput = root.querySelector("[name=url]");
        urlInput.focus();
    }
}
function template(url, title, target) {
    return html `
    <style>
      .modal__form {
        width: 400px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
        padding: 10px 0;
        box-sizing: border-box;
      }

      .modal__input-wrapper {
        position: relative;
        width: 100%;
        display: flex;
        align-items: center;
      }

      .modal__input-buttons {
        position: absolute;
        bottom: 2px;
        right: 2px;
        display: flex;
        align-items: center;
      }

      .modal__file-button {
        position: relative;
        flex: 0 0 26px;
        width: 26px;
        height: 26px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 2px 3px;
        color: var(--eden-grey-500);
        background-color: var(--eden-grey-000);
        border: 0;
        border-radius: var(--eden-radius-100);
        cursor: pointer;
        transition: color 160ms var(--eden-transition-easing),
          background-color 160ms var(--eden-transition-easing);
      }

      .modal__file-button:hover {
        color: var(--eden-secondary-color);
        background-color: var(--eden-grey-200);
      }

      .modal__file-button:focus-visible {
        outline: 2px solid var(--eden-secondary-color);
        outline-offset: 3px;
      }

      .modal__file-button-icon {
        width: 16px;
        height: 16px;
        fill: currentcolor;
        transition: fill 160ms var(--eden-transition-easing);
      }
    </style>
    <div class="modal__form">
      <div class="modal__input-wrapper">
        <eden-input
          type="text"
          label="${t("modals.link.link-label")}"
          name="url"
          value="${url || ""}"
          inputStyles="padding-right: 65px;"
          autofocus
        ></eden-input>
        <div class="modal__input-buttons">
          <button
            is="eden-button"
            tooltip="${t("modals.link.internal-link")}"
            class="modal__file-button"
            id="link-picker"
          >
            <eden-icon code="tree" class="modal__file-button-icon"></eden-icon>
          </button>
        </div>
      </div>
      <eden-input
        type="text"
        label="${t("modals.link.link-title-label")}"
        name="title"
        value="${title || ""}"
      ></eden-input>
      <eden-checkbox
        label="${t("modals.link.open-new-tab")}"
        name="target"
        checked="${target}"
      ></eden-checkbox>
    </div>
  `;
}
