import html from "../../services/html.js";
import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
export default class LastUpdatedWarningModal {
    constructor(onConfirm, lastUpdated, lastUpdatedBy) {
        this.init = () => {
            document.body.append(this.modal);
        };
        this.onConfirm = onConfirm;
        this.lastUpdated = new Date(lastUpdated).toLocaleString("fr-FR", {
            dateStyle: "full",
            timeStyle: "short",
        });
        this.lastUpdatedBy = lastUpdatedBy;
        this.modal = new EdenModal({
            icon: "warning",
            title: t("modals.last-updated-warning.title"),
            content: template(this.lastUpdated, this.lastUpdatedBy),
            buttons: [
                { value: t("common.cancel"), cssClass: "cancel" },
                {
                    value: t("common.continue-anyway"),
                    onClick: onConfirm,
                    cssClass: "danger",
                    autofocus: true,
                },
            ],
        });
    }
}
function template(lastUpdated, lastUpdatedBy) {
    return html `
    <style>
      .modal__inner {
        width: 480px;
        max-width: 100%;
        display: flex;
        flex-direction: column;
        gap: 8px;
        font-size: 16px;
      }

      .modal__text,
      .modal__list {
        margin: 0;
        padding: 0;
      }

      .modal__list {
        padding: 8px;
        background-color: var(--eden-grey-100);
        list-style: none;
        border-radius: var(--eden-radius-200);
      }

      .modal__last-updated,
      .modal__last-updated-at {
        margin: 4px 0;
        font-size: 15px;
        font-family: var(--eden-content-font);
      }

      .modal__icon {
        display: inline-block;
        width: 16px;
        height: 16px;
        fill: currentcolor;
        transform: translateY(4px);
      }
    </style>
    <div class="modal__inner">
      <p class="modal__text">
        <b>${t("modals.last-updated-warning.modified-since-open")}</b>
      </p>
      <p class="modal__text">
        ${t("modals.last-updated-warning.confirm-overwrite")}
      </p>
      <p class="modal__text">${t("modals.last-updated-warning.last-modification")}</p>
      <ul class="modal__list">
        <li class="modal__last-updated">
          <eden-icon code="user" class="modal__icon"></eden-icon>
          ${lastUpdatedBy}
        </li>
        <li class="modal__last-updated-at">
          <eden-icon code="calendar" class="modal__icon"></eden-icon>
          ${lastUpdated}
        </li>
      </ul>
    </div>
  `;
}
