import EdenModal from "../common/eden-modal.js";
import t from "../../i18n/index.js";
export default class FileManagerModal {
    constructor({ callback, width, height, uploadOnly, metadata }) {
        this.render = async () => {
            const callbackWithClose = async (url, metadata) => {
                if (typeof this.callback !== "function")
                    return;
                await this.callback(url, metadata);
                this.close();
            };
            const { default: EdenFileManager } = await import("../file-manager/eden-file-manager.js");
            this.modal = new EdenModal({
                icon: "image",
                title: t("modals.file-manager.title"),
                content: new EdenFileManager({
                    callback: callbackWithClose,
                    width: this.width,
                    height: this.height,
                    uploadOnly: this.uploadOnly,
                    metadata: this.metadata,
                    modal: this.modal,
                }),
                width: 1100,
                height: 670,
                noPadding: true,
            });
            document.body.append(this.modal);
        };
        this.close = () => {
            if (!this.modal)
                return;
            this.modal.close();
        };
        this.callback = callback;
        this.width = width;
        this.height = height;
        this.uploadOnly = uploadOnly;
        this.metadata = metadata;
        this.render();
    }
}
