import css from "../../services/css.js";
const styles = css `
  :host {
    position: fixed;
    bottom: calc(var(--eden-main-ui-height) + 16px);
    left: 16px;
    z-index: 801;
    transform-origin: center center;
    transition: opacity 320ms var(--eden-transition-easing),
      transform 320ms var(--eden-transition-easing);
  }

  :host([closing]) {
    opacity: 0;
    transform: translateY(-120%);
  }

  .indicator {
    position: absolute;
    bottom: 0;
    left: 0;
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 6px 10px;
    color: var(--eden-grey-500);
    font-size: 14px;
    font-weight: 700;
    font-family: var(--eden-content-font);
    background-color: var(--eden-grey-000);
    border-radius: var(--eden-radius-100);
    box-shadow: var(--eden-shadow-200);
    transition: opacity 320ms var(--eden-transition-easing);
  }

  :host([loading]) .indicator--done,
  :host([done]) .indicator--loading {
    opacity: 0;
  }

  .indicator--done {
    color: var(--eden-grey-000);
    background: var(--eden-green-gradient);
  }

  .indicator__icon {
    flex: 0 0 16px;
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }

  :host([loading]) .indicator--loading .indicator__icon {
    animation: indicator-loader-spinning 1280ms var(--eden-transition-easing)
      infinite;
  }

  @keyframes indicator-loader-spinning {
    100% {
      transform: rotate(360deg);
    }
  }

  .indicator__message {
    white-space: nowrap;
  }

  .indicator__info-button {
    flex: 0 0 16px;
    width: 16px;
    height: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    background: transparent;
    border: 0;
    cursor: pointer;
  }

  .indicator__info-icon {
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }
`;
export default styles;
