import html from "../../services/html.js";
import t from "../../i18n/index.js";
const langsLabels = {
    fr: "Français",
    en: "Anglais",
    es: "Espagnol",
    it: "Italien",
    nl: "Néerlandais",
    ru: "Russe",
    pt: "Portugais",
};
export default function template(currentPath) {
    const { lang, langs } = window.EdenConfig;
    const langsHiddenAttribute = langs.length < 2 ? "hidden" : "";
    return html `
    <div class="duplication-form">
      <div class="duplication-form__inner">
        <eden-input
          type="text"
          class="duplication-form__page-source-path"
          label="${t("page.source-page")}"
          value="${currentPath}"
          name="sourcePath"
          readonly
        ></eden-input>
        <div class="duplication-form__selector">
          <eden-input
            type="text"
            class="duplication-form__page-path"
            label="${t("page.destination-page")}"
            placeholder="${t("page.select-page")}"
            value=""
            name="path"
            readonly
          ></eden-input>
          <button
            is="eden-button"
            class="duplication-form__button duplication-form__button--edit-path"
          >
            ${t("page.select-page-button")}
          </button>
        </div>
        <div class="duplication-form__information">
          <eden-icon
            code="information"
            class="duplication-form__information-icon"
          ></eden-icon>
          <div class="duplication-form__information-text">
            ${t("page.duplication-template-info")}
          </div>
        </div>
        <eden-input
          type="select"
          class="duplication-form__lang-selector"
          label="${t("page.destination-lang")}"
          value="${lang}"
          name="lang"
          ${langsHiddenAttribute}
        >
          ${renderLangs(langs)}
        </eden-input>
        <div class="duplication-form__warning">
          <eden-icon
            code="warning"
            class="duplication-form__warning-icon"
          ></eden-icon>
          <div class="duplication-form__warning-text">
            ${t("page.duplication-warning")}<br />
            <b>${t("page.duplication-irreversible")}</b>
          </div>
        </div>
      </div>
      <div class="duplication-form__buttons">
        <eden-checkbox
          class="duplication-form__checkbox"
          label="${t("page.navigate-after-duplication")}"
          name="go-to-destination-page"
        ></eden-checkbox>
        <button
          is="eden-button"
          class="duplication-form__button duplication-form__button--cancel"
        >
          ${t("common.cancel")}
        </button>
        <button
          is="eden-button"
          class="duplication-form__button duplication-form__button--confirm"
          disabled
        >
          ${t("page.duplicate")}
        </button>
      </div>
    </div>
  `;
}
export function confirmModalTemplate(currentPath, selectedPath, lang) {
    const langLabel = langsLabels[lang].toLowerCase();
    return html `
    <div class="confirm-modal">
      ${t("page.duplication-confirm")}
      <span>${currentPath}</span> vers <span>${selectedPath}</span> en
      <b>${langLabel}</b> ?
      <br />
      <br />
      <b>${t("page.duplication-overwrite-info")}</b>
    </div>
  `;
}
function renderLangs(langs) {
    return langs
        .map((lang) => {
        const label = langsLabels[lang] ? `${langsLabels[lang]} (${lang})` : lang;
        return html ` <option value="${lang}">${label}</option> `;
    })
        .join("");
}
