import css from "../../services/css.js";
import keyShortcutsStyles from "../styles/eden-key-shortcuts-styles.js";
const styles = css `
  :host {
    --button-size: 34px;
    --icon-size: 16px;
    --gap: 5px;
    --padding: 4px;

    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    height: var(--eden-main-ui-height);
    display: flex;
    font-family: var(--eden-content-font);
    background: var(--eden-grey-gradient);
    box-shadow: var(--eden-shadow-100);
    border: 1px solid var(--eden-grey-100);
    border-radius: var(--eden-radius-200) var(--eden-radius-200) 0 0;
    z-index: 800;
  }

  .welcome {
    min-width: 0;
    flex: 0 0 auto;
    display: flex;
    align-items: center;
    gap: 1ch;
    color: var(--eden-grey-600);
    padding: 0 12px;
    font-size: 15px;
  }

  .welcome svg {
    --size: 22px;

    flex: 0 0 var(--size);
    width: var(--size);
    height: var(--size);
  }

  .welcome__name {
    font-weight: 700;
  }

  .players:empty {
    display: none;
  }

  .players {
    display: flex;
    align-items: center;
    gap: 6px;
  }

  .player {
    --size: 26px;

    flex: 0 0 var(--size);
    width: var(--size);
    height: var(--size);
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--eden-grey-500);
    font-size: 11px;
    user-select: none;
    cursor: pointer;
    border: 0;
    font-weight: 700;
    background-color: var(--player-color, var(--eden-grey-200));
    border-radius: 50%;
  }

  .actions {
    min-width: 0;
    flex: 1 1 100%;
    display: flex;
    justify-content: flex-end;
    gap: var(--gap);
    padding: var(--padding);
    box-sizing: border-box;
    font-weight: 400;
  }

  .button {
    position: relative;
    width: var(--button-size);
    height: var(--button-size);
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-100);
    cursor: pointer;
    user-select: none;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
    animation: button-appearance 320ms var(--eden-transition-easing);
  }

  @keyframes button-appearance {
    0% {
      opacity: 0;
    }
  }

  .button:disabled {
    cursor: not-allowed;
    opacity: 0.75;
    filter: grayscale(100%);
  }

  .button--small {
    width: var(--button-size-small);
    height: var(--button-size-small);
    background-color: var(--eden-grey-000);
  }

  .button:focus {
    outline: none;
  }

  .button:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .button:not(.button--edit, .button--save):hover {
    background-color: var(--eden-grey-100);
  }

  .button:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .button--edit {
    background: linear-gradient(
      135deg,
      var(--eden-blue-200) 0%,
      var(--eden-magenta-200) 100%
    );
  }

  .button--save {
    background: var(--eden-green-gradient);
  }

  :host([active]) .button--edit {
    display: none;
  }

  .button--save,
  .button--cancel {
    display: none;
  }

  :host([active]) .button--save,
  :host([active]) .button--cancel {
    display: flex;
  }

  :host([active]) .button--save {
    animation: save-button-appearance 160ms var(--eden-transition-easing);
    z-index: 1;
  }

  @keyframes save-button-appearance {
    0% {
      opacity: 0;
    }
  }

  :host([active]) .button--cancel {
    animation: cancel-button-appearance 160ms var(--eden-transition-easing);
  }

  @keyframes cancel-button-appearance {
    0% {
      transform: translateX(50%);
    }
  }

  :host([info]) .button--info {
    background-color: var(--eden-grey-100);
  }

  .button__icon {
    width: var(--icon-size);
    height: var(--icon-size);
    fill: var(--eden-grey-600);
    transition: fill 160ms var(--eden-transition-easing);
  }

  .button:disabled .button__icon {
    opacity: 0.35;
  }

  .button--save .button__icon {
    fill: var(--eden-grey-000);
  }

  :host([info]) .button--info .button__icon {
    fill: var(--eden-magenta-200);
  }

  .button__img {
    width: var(--icon-size);
    height: var(--icon-size);
  }

  .button__spinner {
    width: var(--icon-size);
    height: var(--icon-size);
    fill: var(--eden-grey-000);
    animation: save-spinning 1280ms var(--eden-transition-easing) infinite;
  }

  @keyframes save-spinning {
    100% {
      transform: rotate(360deg);
    }
  }

  .button__notification-dot {
    position: absolute;
    top: 13px;
    right: 7px;
    width: 6px;
    height: 6px;
    border-radius: 50%;
    background-color: var(--eden-red-400);
    border: 1px solid var(--eden-grey-000);
  }

  ${keyShortcutsStyles()}

  .button-separator {
    position: relative;
    top: 10%;
    flex: 0 0 1px;
    width: 1px;
    height: 80%;
    margin: 0;
    background-color: var(--eden-grey-100);
  }

  .button-separator + .button-separator {
    display: none;
  }

  @media (width <= 530px) {
    .welcome,
    .button--cancel + .button-separator,
    .button--preview,
    .button--duplicate,
    .button--translate,
    .button--show-more,
    .button--refresh {
      display: none !important;
    }
  }
`;
export default styles;
