var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenMainUi_edit, _EdenMainUi_info, _EdenMainUi_save, _EdenMainUi_cancel, _EdenMainUi_logout, _EdenMainUi_editNav, _EdenMainUi_toggleInfo, _EdenMainUi_keyDown, _EdenMainUi_openPreview, _EdenMainUi_beforeUnload, _EdenMainUi_refreshSite, _EdenMainUi_openFileManager, _EdenMainUi_duplicatePage, _EdenMainUi_showDuplicationModal, _EdenMainUi_updateUpdatedByTooltip;
import template from "./eden-main-ui.template.js";
import styles from "./eden-main-ui.styles.js";
import { injectStyles } from "../../services/styles.js";
import edenStyles from "../styles/eden-styles.js";
import EdenModal from "../common/eden-modal.js";
import { snackbar } from "../common/eden-snackbar.js";
import { isLocalhost } from "../../services/util.js";
import { fetchClearCache, fetchRevalidate } from "../../services/fetcher.js";
import { fetchRevalidateAll } from "../../services/fetcher.js";
import { saveZones, checkLastUpdated } from "../../services/api.js";
import { generateShortcut } from "../../services/keys.js";
import html from "../../services/html.js";
import t from "../../i18n/index.js";
class EdenMainUi extends HTMLElement {
    constructor() {
        super();
        this.startLoading = () => {
            this.saveButton.innerHTML = html `<eden-icon
      code="loader"
      class="button__spinner"
    ></eden-icon>`;
        };
        this.stopLoading = () => {
            this.saveButton.innerHTML = html `<eden-icon
      code="floppy_disk"
      class="button__icon"
    ></eden-icon>`;
        };
        _EdenMainUi_edit.set(this, () => {
            this.unsavedChanges = true;
            window.Eden.hideInfo();
            window.Eden.activate();
            this.toggleActive();
        });
        _EdenMainUi_info.set(this, () => {
            const isInfo = this.getAttribute("info") !== null;
            if (!isInfo) {
                this.unsavedChanges = false;
                window.Eden.desactivate();
                window.Eden.displayInfo();
            }
            else {
                window.Eden.hideInfo();
            }
            __classPrivateFieldGet(this, _EdenMainUi_toggleInfo, "f").call(this);
        });
        _EdenMainUi_save.set(this, async () => {
            this.unsavedChanges = false;
            this.startLoading();
            await window.Eden.save();
            this.stopLoading();
            this.toggleActive();
            __classPrivateFieldGet(this, _EdenMainUi_updateUpdatedByTooltip, "f").call(this);
        });
        _EdenMainUi_cancel.set(this, () => {
            this.unsavedChanges = false;
            window.Eden.desactivate();
            this.toggleActive();
        });
        _EdenMainUi_logout.set(this, () => {
            this.unsavedChanges = false;
            window.Eden.logout();
        });
        _EdenMainUi_editNav.set(this, async () => {
            const { default: EditStructureModal } = await import("../plugin/edit-structure-modal.js");
            new EditStructureModal().init();
        });
        this.toggleActive = () => {
            const isActive = this.getAttribute("active") !== null;
            if (isActive) {
                this.removeAttribute("active");
            }
            else {
                this.setAttribute("active", "");
                this.removeAttribute("info");
            }
        };
        _EdenMainUi_toggleInfo.set(this, () => {
            const isInfo = this.getAttribute("info") !== null;
            if (isInfo) {
                this.removeAttribute("info");
            }
            else {
                this.setAttribute("info", "");
                this.removeAttribute("active");
            }
        });
        _EdenMainUi_keyDown.set(this, (e) => {
            const isActive = this.getAttribute("active") !== null;
            if (isActive) {
                if ((e.ctrlKey || e.metaKey) && e.key === "s") {
                    e.preventDefault();
                    this.saveButton.focus();
                    __classPrivateFieldGet(this, _EdenMainUi_save, "f").call(this);
                }
            }
            if (this.filemanagerButton) {
                if ((e.ctrlKey || e.metaKey) && e.key === "o") {
                    e.preventDefault();
                    this.filemanagerButton.focus();
                    __classPrivateFieldGet(this, _EdenMainUi_openFileManager, "f").call(this);
                }
            }
            if (e.shiftKey && (e.ctrlKey || e.metaKey) && e.key === "I") {
                e.preventDefault();
                this.infoButton.focus();
                __classPrivateFieldGet(this, _EdenMainUi_info, "f").call(this);
            }
            if (this.editNavButton &&
                e.shiftKey &&
                (e.ctrlKey || e.metaKey) &&
                e.key === "E") {
                e.preventDefault();
                this.editNavButton.focus();
                __classPrivateFieldGet(this, _EdenMainUi_editNav, "f").call(this);
            }
            if (e.shiftKey && e.key === "Escape") {
                e.preventDefault();
                this.logoutButton.focus();
                __classPrivateFieldGet(this, _EdenMainUi_logout, "f").call(this);
            }
            if (!e.shiftKey && (e.ctrlKey || e.metaKey) && e.key === "e") {
                e.preventDefault();
                this.editButton.focus();
                isActive ? __classPrivateFieldGet(this, _EdenMainUi_cancel, "f").call(this) : __classPrivateFieldGet(this, _EdenMainUi_edit, "f").call(this);
            }
            if ((e.ctrlKey || e.metaKey) && e.key === "p") {
                e.preventDefault();
                __classPrivateFieldGet(this, _EdenMainUi_openPreview, "f").call(this);
            }
        });
        _EdenMainUi_openPreview.set(this, () => {
            window.open(window.location.href, "eden • Aperçu", "toolbar=0,location=0,status=0,menubar=0,resizable=1,width=2600,height=1200,left=0,top=0,noopener=1,noreferrer=1");
        });
        _EdenMainUi_beforeUnload.set(this, (e) => {
            if (!this.unsavedChanges || isLocalhost()) {
                return;
            }
            e.preventDefault();
            e.returnValue = true;
        });
        _EdenMainUi_refreshSite.set(this, async () => {
            await fetchClearCache();
            fetchRevalidateAll();
        });
        _EdenMainUi_openFileManager.set(this, async () => {
            const { default: FileManagerModal } = await import("../plugin/file-manager-modal.js");
            new FileManagerModal({ uploadOnly: true });
        });
        _EdenMainUi_duplicatePage.set(this, async (lang, path, ignoreFixedZones) => {
            await saveZones({ lang, path, ignoreFixedZones });
            fetchRevalidate(lang, path);
            snackbar(t("snackbars.content-duplicated"), "success");
        });
        _EdenMainUi_showDuplicationModal.set(this, async () => {
            const { default: EdenPageDuplicationUi } = await import("./eden-page-duplication-ui.js");
            const duplicationModal = new EdenModal({
                title: t("page.duplicate-page"),
                icon: "copy_page",
                content: new EdenPageDuplicationUi(__classPrivateFieldGet(this, _EdenMainUi_duplicatePage, "f")),
                noPadding: true,
            });
            document.body.appendChild(duplicationModal);
        });
        _EdenMainUi_updateUpdatedByTooltip.set(this, async () => {
            const pathname = window.location.pathname;
            const { lastUpdated, lastUpdatedBy } = await checkLastUpdated(pathname);
            const formatedUpdated = new Date(lastUpdated).toLocaleString("fr-FR");
            this.infoButton.setAttribute("tooltip", html `${t("page.updated-by")} <b>${lastUpdatedBy}</b>
        <br />
        ${t("page.updated-at")} <b>${formatedUpdated}</b>
        <br />
        <div style="margin-top: 5px">
          ${t("page.view-info")} ${generateShortcut("ctrl", "shift", "I")}
        </div>`);
        });
        this.user = window.Eden.user;
        this.lastUpdated = undefined;
        this.lastUpdatedBy = undefined;
        this.isEditor = Boolean(this.user?.roles?.includes("eden_editor"));
        this.isAdmin = Boolean(this.user?.roles?.includes("eden_admin"));
        this.isSuperAdmin = Boolean(this.user?.email === "jean_tinland");
        this.unsavedChanges = false;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template({
            firstName: this.user.firstName,
            isEditor: this.isEditor,
            isAdmin: this.isAdmin,
            lastUpdated: this.lastUpdated,
            lastUpdatedBy: this.lastUpdatedBy,
        });
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    static get observedAttributes() {
        return ["active", "info"];
    }
    get active() {
        return this.hasAttribute("active");
    }
    set active(value) {
        if (value) {
            this.setAttribute("active", "");
        }
        else {
            this.removeAttribute("active");
        }
    }
    get info() {
        return this.hasAttribute("info");
    }
    set info(value) {
        if (value) {
            this.setAttribute("info", "");
        }
        else {
            this.removeAttribute("info");
        }
    }
    connectedCallback() {
        __classPrivateFieldGet(this, _EdenMainUi_updateUpdatedByTooltip, "f").call(this);
        this.editButton = this.shadowRoot.querySelector(".button--edit");
        this.infoButton = this.shadowRoot.querySelector(".button--info");
        this.saveButton = this.shadowRoot.querySelector(".button--save");
        this.cancelButton = this.shadowRoot.querySelector(".button--cancel");
        this.logoutButton = this.shadowRoot.querySelector(".button--logout");
        this.editNavButton = this.shadowRoot.querySelector(".button--edit-structure");
        this.filemanagerButton = this.shadowRoot.querySelector(".button--file-manager");
        this.refreshButton = this.shadowRoot.querySelector(".button--refresh");
        this.duplicateButton = this.shadowRoot.querySelector(".button--duplicate");
        this.previewButton = this.shadowRoot.querySelector(".button--preview");
        this.playersContainer = this.shadowRoot.querySelector(".players");
        if (this.filemanagerButton) {
            this.filemanagerButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_openFileManager, "f"));
        }
        if (this.editNavButton && this.isAdmin) {
            this.editNavButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_editNav, "f"));
        }
        if (this.refreshButton) {
            this.refreshButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_refreshSite, "f"));
        }
        if (this.duplicateButton) {
            this.duplicateButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_showDuplicationModal, "f"));
        }
        if (this.previewButton) {
            this.previewButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_openPreview, "f"));
        }
        this.infoButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_info, "f"));
        this.editButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_edit, "f"));
        this.saveButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_save, "f"));
        this.cancelButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_cancel, "f"));
        this.logoutButton.addEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_logout, "f"));
        document.addEventListener("keydown", __classPrivateFieldGet(this, _EdenMainUi_keyDown, "f"));
        window.addEventListener("beforeunload", __classPrivateFieldGet(this, _EdenMainUi_beforeUnload, "f"));
        injectStyles("eden-styles", [edenStyles]);
    }
    disconnectedCallback() {
        window.removeEventListener("beforeunload", __classPrivateFieldGet(this, _EdenMainUi_beforeUnload, "f"));
        document.removeEventListener("keydown", __classPrivateFieldGet(this, _EdenMainUi_keyDown, "f"));
        this.logoutButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_logout, "f"));
        this.cancelButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_cancel, "f"));
        this.saveButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_save, "f"));
        this.editButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_edit, "f"));
        this.infoButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_info, "f"));
        if (this.previewButton) {
            this.previewButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_openPreview, "f"));
        }
        if (this.duplicateButton) {
            this.duplicateButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_showDuplicationModal, "f"));
        }
        if (this.refreshButton) {
            this.refreshButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_refreshSite, "f"));
        }
        if (this.editNavButton && this.isAdmin) {
            this.editNavButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_editNav, "f"));
        }
        if (this.filemanagerButton) {
            this.filemanagerButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenMainUi_openFileManager, "f"));
        }
    }
}
_EdenMainUi_edit = new WeakMap(), _EdenMainUi_info = new WeakMap(), _EdenMainUi_save = new WeakMap(), _EdenMainUi_cancel = new WeakMap(), _EdenMainUi_logout = new WeakMap(), _EdenMainUi_editNav = new WeakMap(), _EdenMainUi_toggleInfo = new WeakMap(), _EdenMainUi_keyDown = new WeakMap(), _EdenMainUi_openPreview = new WeakMap(), _EdenMainUi_beforeUnload = new WeakMap(), _EdenMainUi_refreshSite = new WeakMap(), _EdenMainUi_openFileManager = new WeakMap(), _EdenMainUi_duplicatePage = new WeakMap(), _EdenMainUi_showDuplicationModal = new WeakMap(), _EdenMainUi_updateUpdatedByTooltip = new WeakMap();
export default EdenMainUi;
if (!customElements.get("eden-main-ui")) {
    customElements.define("eden-main-ui", EdenMainUi);
}
