var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenImageCropper_render, _EdenImageCropper_loadImage, _EdenImageCropper_setupResizeObserver, _EdenImageCropper_handleResize, _EdenImageCropper_initializeCropBox, _EdenImageCropper_updateCropBox, _EdenImageCropper_attachEventListeners, _EdenImageCropper_onDragStart, _EdenImageCropper_onDrag, _EdenImageCropper_onDragEnd, _EdenImageCropper_onResizeStart, _EdenImageCropper_onResize, _EdenImageCropper_onResizeEnd, _EdenImageCropper_getCropData;
import template from "./eden-image-cropper.template.js";
import styles from "./eden-image-cropper.styles.js";
import html from "../../services/html.js";
class EdenImageCropper extends HTMLElement {
    constructor({ imageSrc, targetWidth, targetHeight, onCrop, metadata, }) {
        super();
        this.imageElement = null;
        this.containerRect = null;
        this.imageRect = null;
        this.resizeObserver = null;
        this.isLoading = true;
        _EdenImageCropper_render.set(this, () => {
            this.innerHTML = html `
      <style>
        ${styles}
      </style>
      ${template()}
    `;
            this.container = this.querySelector(".cropper-container");
            this.imageElement = this.querySelector(".cropper-image");
            this.cropBoxElement = this.querySelector(".crop-box");
            this.overlay = this.querySelector(".cropper-overlay");
            __classPrivateFieldGet(this, _EdenImageCropper_attachEventListeners, "f").call(this);
        });
        _EdenImageCropper_loadImage.set(this, async () => {
            return new Promise((resolve, reject) => {
                if (!this.imageElement) {
                    reject(new Error("Image element not found"));
                    return;
                }
                this.imageElement.onload = () => {
                    this.isLoading = false;
                    const loader = this.querySelector(".cropper-loader");
                    if (loader) {
                        loader.remove();
                    }
                    this.imageElement.style.opacity = "1";
                    __classPrivateFieldGet(this, _EdenImageCropper_initializeCropBox, "f").call(this);
                    __classPrivateFieldGet(this, _EdenImageCropper_setupResizeObserver, "f").call(this);
                    resolve(void 0);
                };
                this.imageElement.onerror = reject;
                this.imageElement.src = this.imageSrc;
            });
        });
        _EdenImageCropper_setupResizeObserver.set(this, () => {
            this.resizeObserver = new ResizeObserver(() => {
                __classPrivateFieldGet(this, _EdenImageCropper_handleResize, "f").call(this);
            });
            this.resizeObserver.observe(this.container);
        });
        _EdenImageCropper_handleResize.set(this, () => {
            if (!this.imageElement || !this.containerRect || !this.imageRect)
                return;
            const naturalWidth = this.imageElement.naturalWidth;
            const naturalHeight = this.imageElement.naturalHeight;
            const oldScaleX = this.imageRect.width / naturalWidth;
            const oldScaleY = this.imageRect.height / naturalHeight;
            const naturalCropBox = {
                x: this.cropBox.x / oldScaleX,
                y: this.cropBox.y / oldScaleY,
                width: this.cropBox.width / oldScaleX,
                height: this.cropBox.height / oldScaleY,
            };
            this.containerRect = this.container.getBoundingClientRect();
            this.imageRect = this.imageElement.getBoundingClientRect();
            const newScaleX = this.imageRect.width / naturalWidth;
            const newScaleY = this.imageRect.height / naturalHeight;
            this.cropBox = {
                x: naturalCropBox.x * newScaleX,
                y: naturalCropBox.y * newScaleY,
                width: naturalCropBox.width * newScaleX,
                height: naturalCropBox.height * newScaleY,
            };
            this.cropBox.x = Math.max(0, Math.min(this.cropBox.x, this.imageRect.width - this.cropBox.width));
            this.cropBox.y = Math.max(0, Math.min(this.cropBox.y, this.imageRect.height - this.cropBox.height));
            __classPrivateFieldGet(this, _EdenImageCropper_updateCropBox, "f").call(this);
        });
        _EdenImageCropper_initializeCropBox.set(this, () => {
            if (!this.imageElement)
                return;
            this.containerRect = this.container.getBoundingClientRect();
            this.imageRect = this.imageElement.getBoundingClientRect();
            const scale = Math.min(this.imageRect.width / this.imageElement.naturalWidth, this.imageRect.height / this.imageElement.naturalHeight);
            const initialWidth = Math.min(this.targetWidth * scale, this.imageRect.width * 0.8);
            const initialHeight = initialWidth / this.aspectRatio;
            const { x: metadataX, y: metadataY, width: metadataWidth, height: metadataHeight, } = this.metadata || {};
            this.cropBox = {
                x: metadataX !== undefined
                    ? metadataX * scale
                    : (this.imageRect.width - initialWidth) / 2,
                y: metadataY !== undefined
                    ? metadataY * scale
                    : (this.imageRect.height - initialHeight) / 2,
                width: metadataWidth ? metadataWidth * scale : initialWidth,
                height: metadataHeight ? metadataHeight * scale : initialHeight,
            };
            __classPrivateFieldGet(this, _EdenImageCropper_updateCropBox, "f").call(this);
        });
        _EdenImageCropper_updateCropBox.set(this, () => {
            if (!this.cropBoxElement)
                return;
            this.cropBoxElement.style.left = `${this.cropBox.x}px`;
            this.cropBoxElement.style.top = `${this.cropBox.y}px`;
            this.cropBoxElement.style.width = `${this.cropBox.width}px`;
            this.cropBoxElement.style.height = `${this.cropBox.height}px`;
            const clipPath = `polygon(
      0 0,
      100% 0,
      100% 100%,
      0 100%,
      0 0,
      ${this.cropBox.x}px ${this.cropBox.y}px,
      ${this.cropBox.x}px ${this.cropBox.y + this.cropBox.height + 2}px,
      ${this.cropBox.x + this.cropBox.width + 2}px ${this.cropBox.y + this.cropBox.height + 2}px,
      ${this.cropBox.x + this.cropBox.width + 2}px ${this.cropBox.y}px,
      ${this.cropBox.x}px ${this.cropBox.y}px
    )`;
            this.overlay.style.clipPath = clipPath;
        });
        _EdenImageCropper_attachEventListeners.set(this, () => {
            this.cropBoxElement.addEventListener("mousedown", __classPrivateFieldGet(this, _EdenImageCropper_onDragStart, "f"));
            const handles = this.cropBoxElement.querySelectorAll(".crop-box__handle");
            handles.forEach((handle) => {
                handle.addEventListener("mousedown", __classPrivateFieldGet(this, _EdenImageCropper_onResizeStart, "f"));
            });
        });
        _EdenImageCropper_onDragStart.set(this, (e) => {
            const target = e.target;
            if (!target || target.classList.contains("crop-box__handle"))
                return;
            this.isDragging = true;
            this.startX = e.clientX - this.cropBox.x;
            this.startY = e.clientY - this.cropBox.y;
            document.addEventListener("mousemove", __classPrivateFieldGet(this, _EdenImageCropper_onDrag, "f"));
            document.addEventListener("mouseup", __classPrivateFieldGet(this, _EdenImageCropper_onDragEnd, "f"));
            e.preventDefault();
        });
        _EdenImageCropper_onDrag.set(this, (e) => {
            if (!this.isDragging || !this.imageRect)
                return;
            const newX = e.clientX - this.startX;
            const newY = e.clientY - this.startY;
            this.cropBox.x = Math.max(0, Math.min(newX, this.imageRect.width - this.cropBox.width));
            this.cropBox.y = Math.max(0, Math.min(newY, this.imageRect.height - this.cropBox.height));
            __classPrivateFieldGet(this, _EdenImageCropper_updateCropBox, "f").call(this);
        });
        _EdenImageCropper_onDragEnd.set(this, () => {
            this.isDragging = false;
            document.removeEventListener("mousemove", __classPrivateFieldGet(this, _EdenImageCropper_onDrag, "f"));
            document.removeEventListener("mouseup", __classPrivateFieldGet(this, _EdenImageCropper_onDragEnd, "f"));
        });
        _EdenImageCropper_onResizeStart.set(this, (e) => {
            const event = e;
            const target = event.target;
            if (!target || !target.dataset.handle)
                return;
            this.isResizing = true;
            this.resizeHandle = target.dataset.handle;
            this.startX = event.clientX;
            this.startY = event.clientY;
            this.startCropBox = { ...this.cropBox };
            document.addEventListener("mousemove", __classPrivateFieldGet(this, _EdenImageCropper_onResize, "f"));
            document.addEventListener("mouseup", __classPrivateFieldGet(this, _EdenImageCropper_onResizeEnd, "f"));
            e.preventDefault();
            e.stopPropagation();
        });
        _EdenImageCropper_onResize.set(this, (e) => {
            if (!this.isResizing ||
                !this.imageElement ||
                !this.imageRect ||
                !this.resizeHandle) {
                return;
            }
            const deltaX = e.clientX - this.startX;
            let newBox = { ...this.startCropBox };
            const naturalWidth = this.imageElement.naturalWidth;
            const naturalHeight = this.imageElement.naturalHeight;
            const scaleX = this.imageRect.width / naturalWidth;
            const scaleY = this.imageRect.height / naturalHeight;
            const minWidth = Math.max(50, this.targetWidth * scaleX);
            const minHeight = Math.max(50, this.targetHeight * scaleY);
            switch (this.resizeHandle) {
                case "nw":
                    newBox.width = Math.max(minWidth, this.startCropBox.width - deltaX);
                    newBox.height = newBox.width / this.aspectRatio;
                    newBox.x =
                        this.startCropBox.x + (this.startCropBox.width - newBox.width);
                    newBox.y =
                        this.startCropBox.y + (this.startCropBox.height - newBox.height);
                    break;
                case "ne":
                    newBox.width = Math.max(minWidth, this.startCropBox.width + deltaX);
                    newBox.height = newBox.width / this.aspectRatio;
                    newBox.y =
                        this.startCropBox.y + (this.startCropBox.height - newBox.height);
                    break;
                case "sw":
                    newBox.width = Math.max(minWidth, this.startCropBox.width - deltaX);
                    newBox.height = newBox.width / this.aspectRatio;
                    newBox.x =
                        this.startCropBox.x + (this.startCropBox.width - newBox.width);
                    break;
                case "se":
                    newBox.width = Math.max(minWidth, this.startCropBox.width + deltaX);
                    newBox.height = newBox.width / this.aspectRatio;
                    break;
            }
            if (newBox.height < minHeight) {
                newBox.height = minHeight;
                newBox.width = newBox.height * this.aspectRatio;
                if (this.resizeHandle === "nw" || this.resizeHandle === "sw") {
                    newBox.x =
                        this.startCropBox.x + (this.startCropBox.width - newBox.width);
                }
                if (this.resizeHandle === "nw" || this.resizeHandle === "ne") {
                    newBox.y =
                        this.startCropBox.y + (this.startCropBox.height - newBox.height);
                }
            }
            if (newBox.x < 0) {
                newBox.x = 0;
            }
            if (newBox.y < 0) {
                newBox.y = 0;
            }
            if (newBox.x + newBox.width > this.imageRect.width) {
                newBox.x = this.imageRect.width - newBox.width;
                if (newBox.x < 0) {
                    newBox.x = 0;
                    newBox.width = this.imageRect.width;
                    newBox.height = newBox.width / this.aspectRatio;
                }
            }
            if (newBox.y + newBox.height > this.imageRect.height) {
                newBox.y = this.imageRect.height - newBox.height;
                if (newBox.y < 0) {
                    newBox.y = 0;
                    newBox.height = this.imageRect.height;
                    newBox.width = newBox.height * this.aspectRatio;
                }
            }
            this.cropBox = newBox;
            __classPrivateFieldGet(this, _EdenImageCropper_updateCropBox, "f").call(this);
        });
        _EdenImageCropper_onResizeEnd.set(this, () => {
            this.isResizing = false;
            this.resizeHandle = null;
            document.removeEventListener("mousemove", __classPrivateFieldGet(this, _EdenImageCropper_onResize, "f"));
            document.removeEventListener("mouseup", __classPrivateFieldGet(this, _EdenImageCropper_onResizeEnd, "f"));
        });
        this.onConfirm = async () => {
            const cropData = __classPrivateFieldGet(this, _EdenImageCropper_getCropData, "f").call(this);
            if (this.onCrop) {
                await this.onCrop(cropData);
            }
        };
        _EdenImageCropper_getCropData.set(this, () => {
            if (!this.imageElement || !this.imageRect) {
                return { x: 0, y: 0, width: 0, height: 0 };
            }
            const naturalWidth = this.imageElement.naturalWidth;
            const naturalHeight = this.imageElement.naturalHeight;
            const scaleX = naturalWidth / this.imageRect.width;
            const scaleY = naturalHeight / this.imageRect.height;
            return {
                x: Math.round(this.cropBox.x * scaleX),
                y: Math.round(this.cropBox.y * scaleY),
                width: Math.round(this.cropBox.width * scaleX),
                height: Math.round(this.cropBox.height * scaleY),
            };
        });
        this.imageSrc = imageSrc;
        this.targetWidth = targetWidth || 1;
        this.targetHeight = targetHeight || 1;
        this.onCrop = onCrop;
        this.metadata = metadata;
        this.aspectRatio = this.targetWidth / this.targetHeight;
        this.isDragging = false;
        this.isResizing = false;
        this.resizeHandle = null;
        this.startX = 0;
        this.startY = 0;
        this.cropBox = {
            x: 0,
            y: 0,
            width: 200,
            height: 200 / this.aspectRatio,
        };
    }
    connectedCallback() {
        __classPrivateFieldGet(this, _EdenImageCropper_render, "f").call(this);
        __classPrivateFieldGet(this, _EdenImageCropper_loadImage, "f").call(this);
    }
    disconnectedCallback() {
        if (this.resizeObserver) {
            this.resizeObserver.disconnect();
            this.resizeObserver = null;
        }
        document.removeEventListener("mousemove", __classPrivateFieldGet(this, _EdenImageCropper_onDrag, "f"));
        document.removeEventListener("mouseup", __classPrivateFieldGet(this, _EdenImageCropper_onDragEnd, "f"));
        document.removeEventListener("mousemove", __classPrivateFieldGet(this, _EdenImageCropper_onResize, "f"));
        document.removeEventListener("mouseup", __classPrivateFieldGet(this, _EdenImageCropper_onResizeEnd, "f"));
    }
}
_EdenImageCropper_render = new WeakMap(), _EdenImageCropper_loadImage = new WeakMap(), _EdenImageCropper_setupResizeObserver = new WeakMap(), _EdenImageCropper_handleResize = new WeakMap(), _EdenImageCropper_initializeCropBox = new WeakMap(), _EdenImageCropper_updateCropBox = new WeakMap(), _EdenImageCropper_attachEventListeners = new WeakMap(), _EdenImageCropper_onDragStart = new WeakMap(), _EdenImageCropper_onDrag = new WeakMap(), _EdenImageCropper_onDragEnd = new WeakMap(), _EdenImageCropper_onResizeStart = new WeakMap(), _EdenImageCropper_onResize = new WeakMap(), _EdenImageCropper_onResizeEnd = new WeakMap(), _EdenImageCropper_getCropData = new WeakMap();
export default EdenImageCropper;
if (!customElements.get("eden-image-cropper")) {
    customElements.define("eden-image-cropper", EdenImageCropper);
}
