interface Constructor {
    imageSrc: string;
    targetWidth: number;
    targetHeight: number;
    onCrop: (cropData: {
        x: number;
        y: number;
        width: number;
        height: number;
    }) => Promise<void>;
    metadata?: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
}
export default class EdenImageCropper extends HTMLElement {
    #private;
    imageSrc: Constructor["imageSrc"];
    targetWidth: Constructor["targetWidth"];
    targetHeight: Constructor["targetHeight"];
    onCrop: Constructor["onCrop"];
    metadata: Constructor["metadata"];
    aspectRatio: number;
    isDragging: boolean;
    isResizing: boolean;
    resizeHandle: string | null;
    startX: number;
    startY: number;
    startCropBox: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
    cropBox: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
    imageElement: HTMLImageElement | null;
    container: HTMLElement;
    cropBoxElement: HTMLElement;
    overlay: HTMLElement;
    containerRect: DOMRect | null;
    imageRect: DOMRect | null;
    resizeObserver: ResizeObserver | null;
    isLoading: boolean;
    constructor({ imageSrc, targetWidth, targetHeight, onCrop, metadata, }: Constructor);
    onConfirm: () => Promise<void>;
    connectedCallback(): void;
    disconnectedCallback(): void;
}
export {};
//# sourceMappingURL=eden-image-cropper.d.ts.map