import css from "../../services/css.js";
const styles = css `
  eden-file-manager {
    --action-size: 30px;

    flex: 1 1 100%;
    position: relative;
    display: flex;
    flex-direction: column;
  }

  .loader {
    position: absolute;
    top: calc(var(--action-size) + 1px);
    left: 0;
    width: 100%;
    height: 2px;
    display: flex;
    background-color: var(--eden-grey-200);
    overflow: hidden;
  }

  .loader::after {
    content: "";
    flex: 0 0 50%;
    height: 100%;
    background-color: var(--eden-primary-color);
    transform: translateX(-100%);
    animation: loader-bar-sliding 1280ms var(--eden-transition-easing) infinite;
  }

  @keyframes loader-bar-sliding {
    100% {
      transform: translateX(200%);
    }
  }

  .actions {
    flex: 0 0 var(--action-size);
    position: sticky;
    top: 5px;
    display: flex;
    align-items: center;
    gap: 4px;
    padding: 4px;
    box-sizing: border-box;
    background-color: var(--eden-grey-000);
    border-bottom: 1px solid var(--eden-grey-100);
    z-index: 1;
  }

  .separator {
    flex: 0 0 1px;
    width: 1px;
    height: 80%;
    margin: 0;
    background-color: var(--eden-grey-100);
  }

  .spacer {
    flex: 1 1 100%;
  }

  .action {
    position: relative;
    flex: 0 0 var(--action-size);
    width: var(--action-size);
    height: var(--action-size);
    display: flex;
    align-items: center;
    justify-content: center;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-200);
    cursor: pointer;
    transition-property: background-color, box-shadow;
    transition: 160ms var(--eden-transition-easing);
  }

  .action[data-action="optimize"] {
    display: none;
  }

  .action:disabled {
    filter: opacity(0.5) grayscale(1);
    cursor: not-allowed;
  }

  .action:not(:disabled):active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .action:not(:disabled):focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .action:not(:disabled):hover {
    background-color: var(--eden-grey-100);
  }

  .action__icon {
    width: 16px;
    height: 16px;
    fill: var(--eden-grey-600);
    transition: fill 160ms var(--eden-transition-easing);
  }

  .list {
    flex: 1 1 100%;
    display: grid;
    align-items: flex-start;
    align-content: flex-start;
    grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
    grid-template-rows: min-content;
    gap: 4px;
    padding: 6px;
  }

  .list__item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 4px;
    padding: 4px;
    text-align: center;
    font-family: inherit;
    user-select: none;
    cursor: pointer;
    background-color: transparent;
    border: 0;
    border-radius: var(--eden-radius-200);
    transition-property: background-color, box-shadow;
    transition: 160ms var(--eden-transition-easing);
  }

  .list__item:disabled {
    cursor: not-allowed;
  }

  .list__item:not(:disabled, [data-selected]):active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .list__item:not(:disabled):focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .list__item:not(:disabled, [data-selected]):hover {
    background-color: var(--eden-grey-100);
  }

  .list__item[data-selected] {
    background-color: var(--eden-grey-100);
    box-shadow: 0 0 0 1px var(--eden-secondary-color) inset;
  }

  .list__item-preview {
    align-self: stretch;
    position: relative;
    flex: 0 0 80px;
    height: 80px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 4px;
  }

  .list__item[data-image][data-loading] .list__item-preview::before {
    --offset-x: 20px;
    --offset-y: 10px;

    content: "";
    position: absolute;
    top: var(--offset-y);
    left: var(--offset-x);
    width: calc(100% - (var(--offset-x) * 2));
    height: calc(100% - (var(--offset-y) * 2));
    background: linear-gradient(
      -45deg,
      var(--eden-grey-300),
      var(--eden-grey-100),
      var(--eden-grey-200),
      var(--eden-grey-500)
    );
    background-size: 400% 400%;
    background-position: 0% 50%;
    animation: loader-gradient-gliding 1280ms ease infinite;
    border-radius: var(--eden-radius-100);
  }

  @keyframes loader-gradient-gliding {
    50% {
      background-position: 100% 50%;
    }
  }

  .list__item-preview img {
    max-width: 100%;
    width: auto;
    max-height: 100%;
    height: auto;
    border-radius: var(--eden-radius-100);
  }

  .list__item:disabled .list__item-preview img {
    filter: opacity(0.5) grayscale(1);
  }

  .list__item-warning {
    font-family: var(--eden-content-font);
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) rotate(-4deg);
    color: var(--eden-red-400);
    font-size: 12px;
    white-space: nowrap;
    padding: 2px 4px;
    border: 1px solid var(--eden-red-300);
    border-radius: var(--eden-radius-100);
  }

  .list__folder-icon {
    --size: 42px;

    flex: 0 0 var(--size);
    width: var(--size);
    height: var(--size);
    padding: 6px;
    box-sizing: border-box;
    background-color: var(--eden-primary-color);
    border-radius: var(--eden-radius-100);
  }

  .list__item-name {
    margin-bottom: 8px;
    color: var(--eden-grey-500);
    font-size: 13px;
    word-break: break-all;
  }

  footer {
    flex: 0 0 var(--action-size);
    position: sticky;
    bottom: 0;
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    background-color: var(--eden-grey-000);
  }

  .breadcrumb {
    flex: 1 0 auto;
    display: flex;
    border-top: 1px solid var(--eden-grey-100);
  }

  .breadcrumb .separator {
    transform: skewX(-15deg);
  }

  .breadcrumb__item {
    position: relative;
    flex: 0 1 auto;
    height: var(--action-size);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 8px;
    color: var(--eden-grey-600);
    font-size: 13px;
    font-family: inherit;
    background-color: transparent;
    border: 0;
    cursor: pointer;
    transition: box-shadow 160ms var(--eden-transition-easing);
  }

  .breadcrumb__item:disabled {
    filter: opacity(0.5) grayscale(1);
    cursor: not-allowed;
  }

  .breadcrumb__item:not(:disabled):active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .breadcrumb__item:not(:disabled):focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .breadcrumb__item:not(:disabled):hover {
    text-decoration: underline;
  }

  .breadcrumb__icon {
    width: 16px;
    height: 16px;
    fill: var(--eden-grey-600);
    transition: fill 160ms var(--eden-transition-easing);
    cursor: pointer;
  }

  .progress {
    flex: 1 1 auto;
    display: flex;
    align-items: center;
    justify-content: flex-end;
    gap: 6px;
    padding: 2px 6px;
    font-size: 12px;
    accent-color: var(--eden-green-100);
    border-top: 1px solid var(--eden-grey-100);
  }

  .progress--warn {
    accent-color: var(--eden-yellow-100);
  }

  .progress--error {
    accent-color: var(--eden-red-100);
  }
`;
export default styles;
