import EdenModal from "../common/eden-modal.js";
import type { FileManagerItem, FileManagerList, FileManagerStorage } from "../../types.js";
interface Constructor {
    modal: EdenModal;
    callback: (url: string, metadata: string) => void | Promise<void>;
    width?: number;
    height?: number;
    uploadOnly?: boolean;
    metadata?: string | null;
}
export default class EdenFileManager extends HTMLElement {
    #private;
    modal: Constructor["modal"];
    callback: Constructor["callback"];
    width: Constructor["width"];
    height: Constructor["height"];
    uploadOnly: Constructor["uploadOnly"];
    bareMetadata: Constructor["metadata"];
    metadata?: {
        x: number;
        y: number;
        width: number;
        height: number;
        path: string;
    };
    currentPath: string;
    selectedItem: FileManagerItem | null;
    loader: HTMLDivElement | null;
    breadcrumb: HTMLElement;
    list: HTMLElement;
    actions: HTMLElement;
    uploadInput: HTMLInputElement;
    files: FileManagerList;
    storage: FileManagerStorage;
    constructor({ modal, callback, width, height, uploadOnly, metadata, }: Constructor);
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
}
export {};
//# sourceMappingURL=eden-file-manager.d.ts.map