import html from "../../services/html.js";
export default function render({ label, selected, options, availableOptions, multiple, dropdownOpened, helper, }) {
    return html `
    <div class="tag-manager">
      <div class="tag-manager__label">${label}</div>
      <div class="tag-manager__inner">
        ${renderSelected(selected, options)}
        ${renderOptions(availableOptions, selected, multiple, dropdownOpened)}
      </div>
      ${renderHelper(helper)}
    </div>
  `;
}
function renderOptions(availableOptions, selected, multiple, dropdownOpened) {
    if (!availableOptions.length)
        return "";
    const selectOptions = availableOptions
        .map((option) => html `<button is="eden-button" class="tag-manager__option">
          ${option}
        </button>`)
        .join("");
    return html `
    <div class="tag-manager__options">
      ${!selected.length || (multiple && availableOptions.length)
        ? html `
            <button is="eden-button" class="tag-manager__options-add">
              <eden-icon code="plus"></eden-icon>
            </button>
          `
        : ""}
      ${dropdownOpened
        ? html `
            <div class="tag-manager__options-list-backdrop"></div>
            <div class="tag-manager__options-list">${selectOptions}</div>
          `
        : ""}
    </div>
  `;
}
function renderSelected(selected, options) {
    return selected
        .map((item) => {
        const isValid = options.includes(item);
        const classes = isValid
            ? "tag-manager__item"
            : "tag-manager__item tag-manager__item--outdated";
        return html ` <button is="eden-button" class="${classes}">
        <span>${item}</span>
        <eden-icon code="close"></eden-icon>
      </button>`;
    })
        .join("");
}
function renderHelper(helper) {
    if (!helper?.length)
        return "";
    return html `<div class="tag-manager__helper">${helper}</div>`;
}
