import css from "../../services/css.js";
const styles = css `
  eden-tag-manager {
    width: 100%;
  }

  .tag-manager {
    font-family: var(--eden-content-font);
  }

  .tag-manager__label {
    margin-bottom: 4px;
    font-size: 13px;
    color: var(--eden-grey-500);
    user-select: none;
  }

  .tag-manager__inner {
    min-height: 42px;
    display: flex;
    flex-wrap: wrap;
    gap: 6px;
    padding: 6px;
    box-sizing: border-box;
    background-color: var(--eden-grey-100);
    border: 1px solid var(--eden-grey-300);
    border-radius: var(--eden-radius-200);
  }

  .tag-manager__item {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 4px 8px;
    color: var(--eden-grey-500);
    font-weight: 700;
    font-family: var(--eden-content-font);
    font-size: 13px;
    text-decoration: none;
    white-space: nowrap;
    background-color: var(--eden-grey-000);
    border: none;
    border-radius: var(--eden-radius-100);
    user-select: none;
    cursor: pointer;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .tag-manager__item--outdated {
    color: var(--eden-grey-000);
    background-color: var(--eden-yellow-400);
  }

  .tag-manager__item:focus,
  .tag-manager__options-add:focus {
    outline: none;
  }

  .tag-manager__item:focus-visible,
  .tag-manager__options-add:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .tag-manager__item:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .tag-manager__item > span {
    padding-bottom: 2px;
  }

  .tag-manager__item > eden-icon {
    width: 15px;
    height: 15px;
    margin-left: 4px;
    fill: currentcolor;
  }

  .tag-manager__options {
    align-self: center;
    position: relative;
  }

  .tag-manager__options-add {
    display: flex;
    align-items: center;
    padding: 3px;
    background-color: var(--eden-grey-000);
    border: none;
    border-radius: var(--eden-radius-100);
    user-select: none;
    cursor: pointer;
    transition: box-shadow 160ms var(--eden-transition-easing);
  }

  .tag-manager__options-add:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .tag-manager__options-add > eden-icon {
    width: 18px;
    height: 18px;
    fill: var(--eden-grey-500);
  }

  .tag-manager__options-list {
    position: absolute;
    top: 0;
    max-height: 400px;
    display: flex;
    flex-direction: column;
    padding: 10px;
    box-sizing: border-box;
    font-family: var(--eden-content-font);
    font-weight: 400;
    font-size: 14px;
    color: var(--eden-grey-500);
    text-align: left;
    background-color: var(--eden-grey-000);
    box-shadow: var(--eden-shadow-200);
    border-radius: var(--eden-radius-200);
    overflow: auto;
    animation: select-options-appearance 160ms var(--eden-transition-easing);
    z-index: 901;
  }

  @keyframes select-options-appearance {
    0% {
      opacity: 0;
    }
  }

  .tag-manager__options-list-backdrop {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.25);
    z-index: 900;
  }

  .tag-manager__option {
    position: relative;
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 6px 8px;
    background-color: transparent;
    font-family: var(--eden-content-font);
    font-weight: 400;
    font-size: 15px;
    white-space: nowrap;
    user-select: none;
    text-align: left;
    border: 0;
    border-radius: var(--eden-radius-200);
    cursor: pointer;
    transition-property: color, background-color, box-shadow;
    transition: 160ms var(--eden-transition-easing);
  }

  .tag-manager__option:hover {
    background-color: var(--eden-grey-100);
  }

  .tag-manager__option:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .tag-manager__helper {
    margin-top: 3px;
    color: var(--eden-grey-500);
    font-size: 11px;
  }
`;
export default styles;
