var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenTagManager_getSelected, _EdenTagManager_draw, _EdenTagManager_add, _EdenTagManager_remove, _EdenTagManager_getAvailableOptions, _EdenTagManager_open, _EdenTagManager_close;
import template from "./eden-tag-manager.template.js";
import styles from "./eden-tag-manager.styles.js";
import html from "../../services/html.js";
class EdenTagManager extends HTMLElement {
    constructor() {
        super();
        _EdenTagManager_getSelected.set(this, () => {
            this.value = this.getAttribute("value") || "";
            return (this.value
                ?.split(",")
                .map((entry) => entry.trim())
                .filter((item) => item.length) || []);
        });
        _EdenTagManager_draw.set(this, () => {
            this.selected = __classPrivateFieldGet(this, _EdenTagManager_getSelected, "f").call(this);
            __classPrivateFieldGet(this, _EdenTagManager_getAvailableOptions, "f").call(this);
            this.innerHTML = html `
      <style>
        ${styles}
      </style>
      ${template({
                label: this.label,
                selected: this.selected,
                options: this.options,
                availableOptions: this.availableOptions,
                multiple: this.multiple,
                dropdownOpened: this.dropdownOpened,
                helper: this.helper,
            })}
    `;
        });
        _EdenTagManager_add.set(this, (e) => {
            const target = e.target;
            const option = target?.closest(".tag-manager__option");
            if (!option)
                return;
            const value = option.textContent.trim();
            this.selected = [...this.selected, value];
            this.setAttribute("value", this.selected.join(","));
            this.dropdownOpened = false;
            __classPrivateFieldGet(this, _EdenTagManager_draw, "f").call(this);
        });
        _EdenTagManager_remove.set(this, (e) => {
            const target = e.target;
            const item = target?.closest(".tag-manager__item");
            if (!item)
                return;
            const value = item.textContent.trim();
            this.selected = [...this.selected].filter((item) => item !== value);
            this.setAttribute("value", this.selected.join(","));
            __classPrivateFieldGet(this, _EdenTagManager_draw, "f").call(this);
        });
        _EdenTagManager_getAvailableOptions.set(this, () => {
            this.availableOptions = this.options.filter((entry) => !this.selected.includes(entry));
        });
        _EdenTagManager_open.set(this, (e) => {
            const target = e.target;
            const optionsAdd = target?.closest(".tag-manager__options-add");
            if (!optionsAdd)
                return;
            this.dropdownOpened = true;
            __classPrivateFieldGet(this, _EdenTagManager_draw, "f").call(this);
        });
        _EdenTagManager_close.set(this, (e) => {
            const target = e.target;
            const backdrop = target?.closest(".tag-manager__options-list-backdrop");
            if (!backdrop)
                return;
            this.dropdownOpened = false;
            __classPrivateFieldGet(this, _EdenTagManager_draw, "f").call(this);
        });
        this.label = this.getAttribute("label") || "";
        this.name = this.getAttribute("name") || "";
        this.multiple = this.hasAttribute("multiple");
        this.helper = this.getAttribute("helper");
        this.selected = __classPrivateFieldGet(this, _EdenTagManager_getSelected, "f").call(this);
        this.options =
            this.getAttribute("options")
                ?.split(",")
                .map((entry) => entry.trim().replace(/,/g, "")) || [];
        this.dropdownOpened = false;
        __classPrivateFieldGet(this, _EdenTagManager_draw, "f").call(this);
    }
    static get observedAttributes() {
        return ["value"];
    }
    attributeChangedCallback(name, _, newValue) {
        if (name === "value" && newValue !== this.value) {
            __classPrivateFieldGet(this, _EdenTagManager_draw, "f").call(this);
        }
    }
    connectedCallback() {
        this.addEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_remove, "f"));
        this.addEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_open, "f"));
        this.addEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_close, "f"));
        this.addEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_add, "f"));
    }
    disconnectedCallback() {
        this.removeEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_add, "f"));
        this.removeEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_close, "f"));
        this.removeEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_open, "f"));
        this.removeEventListener("click", __classPrivateFieldGet(this, _EdenTagManager_remove, "f"));
    }
}
_EdenTagManager_getSelected = new WeakMap(), _EdenTagManager_draw = new WeakMap(), _EdenTagManager_add = new WeakMap(), _EdenTagManager_remove = new WeakMap(), _EdenTagManager_getAvailableOptions = new WeakMap(), _EdenTagManager_open = new WeakMap(), _EdenTagManager_close = new WeakMap();
export default EdenTagManager;
if (!customElements.get("eden-tag-manager")) {
    customElements.define("eden-tag-manager", EdenTagManager);
}
