var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenSnackbar_close, _EdenSnackbar_init, _EdenSnackbar_deleteAllOtherSnackbar;
import template from "./eden-snackbar.template.js";
import styles from "./eden-snackbar.styles.js";
class EdenSnackbar extends HTMLElement {
    constructor(options) {
        super();
        _EdenSnackbar_close.set(this, () => {
            this.setAttribute("animate", "");
            setTimeout(() => this.remove(), 300);
        });
        _EdenSnackbar_init.set(this, () => {
            if (!this.options.icon) {
                this.icon.remove();
            }
            __classPrivateFieldGet(this, _EdenSnackbar_deleteAllOtherSnackbar, "f").call(this);
            setTimeout(() => {
                if (this.options.message === "")
                    return;
                this.shadowRoot.innerHTML = template();
                const sheet = new CSSStyleSheet();
                sheet.replaceSync(styles);
                this.shadowRoot.adoptedStyleSheets = [sheet];
                this.text = this.shadowRoot.querySelector(".snackbar__text");
                this.icon = this.shadowRoot.querySelector(".snackbar__icon");
                this.closeButton = this.shadowRoot.querySelector(".snackbar__close");
                if (this.options.closeButton) {
                    this.closeButton.addEventListener("click", __classPrivateFieldGet(this, _EdenSnackbar_close, "f"));
                }
                else {
                    this.closeButton.remove();
                }
                this.text.innerText = this.options.message;
                this.setAttribute("type", this.options.type);
                this.icon.setAttribute("code", this.options.type);
                setTimeout(() => {
                    this.removeAttribute("animate");
                }, 240);
            }, this.delay);
        });
        _EdenSnackbar_deleteAllOtherSnackbar.set(this, () => {
            const snackbars = Array.from(document.querySelectorAll("eden-snackbar"));
            this.delay = snackbars.length > 1 ? 300 : 0;
            snackbars.forEach((snackbar) => {
                if (snackbar !== this) {
                    snackbar.classList.add("snackbar--animate");
                    setTimeout(() => snackbar.remove(), 300);
                }
            });
        });
        this.defaults = {
            message: "",
            icon: true,
            type: "information",
            closeButton: true,
            delay: 6000,
        };
        this.options = Object.assign({}, this.defaults, options);
        this.delay = 0;
        this.attachShadow({ mode: "open" });
    }
    connectedCallback() {
        __classPrivateFieldGet(this, _EdenSnackbar_init, "f").call(this);
        setTimeout(() => {
            __classPrivateFieldGet(this, _EdenSnackbar_close, "f").call(this);
        }, this.options.delay);
    }
    disconnectedCallback() {
        if (this.options.closeButton) {
            this.closeButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenSnackbar_close, "f"));
        }
    }
}
_EdenSnackbar_close = new WeakMap(), _EdenSnackbar_init = new WeakMap(), _EdenSnackbar_deleteAllOtherSnackbar = new WeakMap();
if (!customElements.get("eden-snackbar")) {
    customElements.define("eden-snackbar", EdenSnackbar);
}
export function snackbar(message, type = "information", delay = 3000) {
    document.body.prepend(new EdenSnackbar({
        message,
        type,
        delay,
    }));
}
