import html from "../../services/html.js";
import { generateShortcut } from "../../services/keys.js";
import t from "../../i18n/index.js";
export default function template() {
    const closeTooltip = `${t("ui.modal.close")} ${generateShortcut(t("common.escape"))}`;
    return html `
    <div class="backdrop"></div>
    <div class="modal notranslate">
      <div class="modal__header">
        <button
          is="eden-button"
          tooltip="${closeTooltip}"
          class="modal__close-button"
        >
          <eden-icon code="close" class="modal__close-button-icon"></eden-icon>
        </button>
        <div class="modal__title"></div>
      </div>
      <div class="modal__content"></div>
      <div class="modal__buttons"></div>
    </div>
  `;
}
