import library from "../icons/library/index.js";
interface Button {
    cssClass: "confirm" | "cancel" | string;
    value: string;
    onClick?: (modal: EdenModal) => void;
    autofocus?: boolean;
    keepOpened?: boolean;
}
interface Options {
    width?: number;
    height?: number;
    icon?: keyof typeof library;
    title: string;
    content: string | HTMLElement;
    buttons: Button[];
    backdrop: boolean;
    closeButton: boolean;
    onClose?: (modal: EdenModal) => void;
    noPadding: boolean;
    fullScreen: boolean;
}
export default class EdenModal extends HTMLElement {
    #private;
    defaults: Options;
    options: Options;
    shadowRoot: ShadowRoot;
    modal: HTMLElement;
    closeButton: HTMLElement;
    backdrop: HTMLElement;
    modalTitle: HTMLElement;
    modalContent: HTMLElement;
    modalButtons: HTMLElement;
    focusableContent: HTMLElement[];
    firstFocusableElement: HTMLElement;
    lastFocusableElement: HTMLElement;
    constructor(options: Partial<Options>);
    close: () => void;
    connectedCallback(): void;
    disconnectedCallback(): void;
}
export {};
//# sourceMappingURL=eden-modal.d.ts.map