import css from "../../services/css.js";
export default function styles({ type, children }) {
    const addionalInputStyles = type !== "select" && children ? children : "";
    return css `
    eden-input {
      width: 100%;
      display: flex;
      flex-direction: column;
      font-family: var(--eden-content-font);
      font-weight: 400;
    }

    eden-input[hidden] {
      display: none !important;
    }

    eden-input[disabled] {
      opacity: 0.5;
      cursor: not-allowed;
    }

    eden-input[type="select"] {
      width: auto;
      align-items: flex-start;
    }

    .eden-input__label {
      display: flex;
      align-items: center;
      margin-bottom: 4px;
      font-size: 13px;
      color: var(--eden-grey-500);
      user-select: none;
    }

    .eden-input__input-container {
      position: relative;
      border-radius: var(--eden-radius-200);
      z-index: 0;
    }

    .eden-input__input-container--select {
      width: fit-content;
    }

    .eden-input__input {
      position: relative;
      width: 100%;
      height: 34px;
      padding: 6px;
      box-sizing: border-box;
      font-size: 15px;
      font-family: inherit;
      color: var(--eden-grey-500);
      background-color: var(--eden-grey-100);
      border: 1px solid var(--eden-grey-200);
      border-radius: inherit;
      outline: none;
      z-index: 3;
      transition: border 320ms var(--eden-transition-easing);
    }

    eden-input[disabled] :is(.eden-input__label, .eden-input__input) {
      cursor: not-allowed;
    }

    eden-input[readonly] :is(.eden-input__label, .eden-input__input) {
      cursor: default;
    }

    .eden-input__input:focus {
      border: 1px solid var(--eden-grey-400);
    }

    .eden-input__input:focus,
    .eden-input__input:focus-within,
    .eden-input__input:focus-visible {
      outline: none;
    }

    .eden-input__input--select {
      width: auto;
      padding: 8px 28px 8px 8px;
      border-radius: inherit;
      background-image: url("data:image/svg+xml, %3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' fill='%23fff' viewBox='0 0 24 24'%3E%3Cpath d='M7.406 7.828l4.594 4.594 4.594-4.594 1.406 1.406-6 6-6-6z'%3E%3C/path%3E%3C/svg%3E");
      background-position: calc(100% - 3px) 50%;
      background-repeat: no-repeat;
      background-size: 16px;
      appearance: none;
      -webkit-appearance: none;
      -moz-appearance: none;
    }

    .eden-input__input--textarea {
      min-height: 80px;
      display: block;
      resize: none;
      font-family: inherit;
    }

    .eden-input__description-count-container {
      align-self: flex-end;
      display: flex;
      align-items: center;
      margin-top: 10px;
      font-size: 12px;
      color: var(--eden-grey-500);
      user-select: none;
    }

    .eden-input__helper {
      margin-top: 3px;
      color: var(--eden-grey-500);
      font-size: 11px;
    }

    ${addionalInputStyles}
  `;
}
