var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenInput_onInput;
import template from "./eden-input.template.js";
import styles from "./eden-input.styles.js";
import html from "../../services/html.js";
class EdenInput extends HTMLElement {
    constructor() {
        super();
        this.focus = () => {
            this.input.focus();
        };
        _EdenInput_onInput.set(this, (e) => {
            const target = e.target;
            this.value = target.value;
            this.setAttribute("value", this.value);
        });
        this.name = this.getAttribute("name");
        this.label = this.getAttribute("label");
        this.pill = this.getAttribute("pill");
        this.type = this.getAttribute("type");
        this.autofocus = this.hasAttribute("autofocus");
        this.autocomplete = this.getAttribute("autocomplete");
        this.value = this.getAttribute("value") || "";
        this.inputStyles = this.getAttribute("inputStyles");
        this.placeholder = this.getAttribute("placeholder");
        this.helper = this.getAttribute("helper");
        this.disabled = this.hasAttribute("disabled");
        this.readonly = this.hasAttribute("readonly");
        this.pattern = this.getAttribute("pattern");
        this.spellCheck = this.getAttribute("spellcheck") || "true";
        this.childrenHTML = this.innerHTML;
        this.innerHTML = html `
      <style>
        ${styles({
            type: this.type,
            children: this.childrenHTML,
        })}
      </style>
      ${template({
            name: this.name,
            label: this.label,
            pill: this.pill,
            type: this.type,
            autofocus: this.autofocus,
            autocomplete: this.autocomplete,
            value: this.value,
            placeholder: this.placeholder,
            helper: this.helper,
            pattern: this.pattern,
            spellCheck: this.spellCheck,
            inputStyles: this.inputStyles,
            children: this.childrenHTML,
        })}
    `;
        this.input = this.querySelector("input, textarea, select");
        this.options = Array.from(this.input.querySelectorAll("option"));
    }
    connectedCallback() {
        this.input.value = this.value;
        this.input.addEventListener("input", __classPrivateFieldGet(this, _EdenInput_onInput, "f"));
        this.input.addEventListener("change", __classPrivateFieldGet(this, _EdenInput_onInput, "f"));
        if (this.autofocus) {
            this.input.focus();
        }
    }
    disconnectedCallback() {
        this.input.removeEventListener("change", __classPrivateFieldGet(this, _EdenInput_onInput, "f"));
        this.input.removeEventListener("input", __classPrivateFieldGet(this, _EdenInput_onInput, "f"));
    }
    static get observedAttributes() {
        return ["value", "disabled", "readonly"];
    }
    attributeChangedCallback(name, _, newValue) {
        if (name === "value") {
            this.value = newValue;
            this.input.value = this.value;
            if (this.type === "select") {
                this.options.forEach((option) => {
                    if (option.value === this.value) {
                        option.setAttribute("selected", "");
                    }
                    else {
                        option.removeAttribute("selected");
                    }
                });
            }
        }
        if (name === "disabled") {
            this.disabled = this.hasAttribute("disabled");
            if (this.disabled) {
                this.input.setAttribute("disabled", "");
            }
            else {
                this.input.removeAttribute("disabled");
            }
        }
        if (name === "readonly") {
            this.readonly = this.hasAttribute("readonly");
            if (this.readonly) {
                this.input.setAttribute("readonly", "");
            }
            else {
                this.input.removeAttribute("readonly");
            }
        }
    }
}
_EdenInput_onInput = new WeakMap();
export default EdenInput;
if (!customElements.get("eden-input")) {
    customElements.define("eden-input", EdenInput);
}
