import t from "../../i18n/index.js";
import html from "../../services/html.js";
export default function template({ id, group, name, tags, variants, classList, hidden, }) {
    return html `
    <div class="helper">
      <div class="helper__title">${t("ui.helper.title")}</div>
      <div class="helper__content">
        ${renderId(id)}
        <div class="helper__group">
          <b>${t("ui.helper.group")}</b> : ${group}
        </div>
        <div class="helper__name">
          <b>${t("ui.helper.section")}</b> : ${name}
        </div>
        ${renderTags(tags)} ${renderVariant(variants, classList)}
        ${renderHidden(hidden)}
      </div>
    </div>
  `;
}
function renderId(id) {
    if (!id)
        return "";
    return html ` <div class="helper__id">#<b>${id}</b></div> `;
}
function renderTags(tags) {
    if (!tags)
        return "";
    return html ` <div class="helper__tags"><b>Tags</b> : ${tags}</div> `;
}
function renderVariant(variants, classList) {
    if (!variants || !classList)
        return "";
    let variant = "";
    variants.forEach((v) => {
        if (classList.contains(v.cssClass)) {
            variant = html `
        <div class="helper__variant"><b>Variante</b> : ${v.name}</div>
      `;
        }
    });
    return variant;
}
function renderHidden(hidden) {
    if (!hidden)
        return "";
    return html `
    <div class="helper__hidden">
      <i>Section cachée</i>
    </div>
  `;
}
