import css from "../../services/css.js";
const styles = css `
  :host {
    position: fixed;
    top: 0;
    left: 0;
    max-width: 380px;
    z-index: 1300;
    pointer-events: none;
    animation: information-appearance 240ms var(--eden-transition-easing);
  }

  @keyframes information-appearance {
    0% {
      opacity: 0;
    }
  }

  .helper {
    display: flex;
    flex-direction: column;
    color: var(--eden-grey-600);
    font-size: 15px;
    font-family: var(--eden-content-font);
    font-weight: 400;
    background-color: var(--eden-grey-000);
    border: 1px solid var(--eden-grey-100);
    border-radius: var(--eden-radius-200);
    box-shadow: var(--eden-shadow-100);
  }

  .helper__title {
    padding: 6px 10px 4px 10px;
    font-weight: 700;
    background-color: var(--eden-grey-100);
    border-bottom: 1px solid var(--eden-grey-200);
    border-radius: var(--eden-radius-200) var(--eden-radius-200) 0 0;
  }

  .helper__content {
    padding: 10px;
    border-radius: 0 0 var(--eden-radius-200) var(--eden-radius-200);
  }

  .helper__variant {
    color: var(--eden-secondary-color);
  }

  .helper__hidden {
    color: var(--eden-red-400);
  }

  .helper__msem {
    font-weight: 700;
  }
`;
export default styles;
