import template from "./eden-helper.template.js";
import styles from "./eden-helper.styles.js";
export default class EdenHelper extends HTMLElement {
    constructor(block) {
        super();
        this.templates = window.Eden.templates;
        this.block = block;
        this.templateName = this.block.dataset.template;
        const matchingTemplate = this.templates[this.templateName];
        const group = matchingTemplate?.group;
        const groups = matchingTemplate?.groups;
        this.data = {
            id: this.block.id,
            group: (groups?.length && groups?.length > 0
                ? `${group}, ${groups.join(", ")}`
                : group),
            name: matchingTemplate?.name,
            tags: this.block?.dataset?.tags,
            variants: matchingTemplate?.variants,
            classList: this.block.classList,
            hidden: this.block?.dataset?.hidden,
        };
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = this.templateName ? template(this.data) : "";
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() { }
    disconnectedCallback() { }
}
if (!customElements.get("eden-helper")) {
    customElements.define("eden-helper", EdenHelper);
}
