import css from "../../services/css.js";
const styles = css `
  eden-checkbox {
    display: flex;
    flex-direction: row;
    font-family: var(--eden-content-font);
    font-weight: 400;
  }

  eden-checkbox[disabled] {
    opacity: 0.5;
    filter: grayscale(100%);
    cursor: not-allowed;
  }

  .checkbox__label {
    position: relative;
    height: 22px;
    display: flex;
    align-items: center;
    font-size: 13px;
    color: var(--eden-grey-500);
    cursor: pointer;
    user-select: none;
  }

  .checkbox__input {
    position: absolute;
    height: 0;
    width: 0;
    opacity: 0;
    cursor: pointer;
  }

  eden-checkbox[disabled] :is(.checkbox__label, .checkbox__input) {
    cursor: not-allowed;
  }

  .checkbox__checkmark {
    position: relative;
    flex: 0 0 20px;
    width: 20px;
    height: 20px;
    margin-right: 10px;
    background-color: var(--eden-grey-100);
    border: 1px solid var(--eden-grey-200);
    border-radius: calc(var(--eden-radius-100) * 2);
    transform-origin: center;
    transition: background-color 160ms var(--eden-transition-easing),
      transform 320ms var(--eden-transition-easing);
  }

  .checkbox__label:focus-within .checkbox__checkmark {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .checkbox__checkmark::before,
  .checkbox__checkmark::after {
    content: "";
    position: absolute;
    width: 0;
    height: 2px;
    background-color: var(--eden-secondary-color);
    border-radius: var(--eden-radius-100);
    transform-origin: 0% 0%;
  }

  .checkbox__checkmark::before {
    top: 9px;
    left: 7px;
    transform: rotate(45deg);
    transition: width 100ms 100ms var(--eden-transition-easing);
  }

  .checkbox__checkmark::after {
    top: 13px;
    left: 8px;
    transform: rotate(305deg);
    transition: width 100ms var(--eden-transition-easing);
  }

  .checkbox__input:checked + .checkbox__checkmark::before {
    width: 5px;
    transition: width 100ms var(--eden-transition-easing);
  }

  .checkbox__input:checked + .checkbox__checkmark::after {
    width: 10px;
    transition: width 100ms 100ms var(--eden-transition-easing);
  }

  .checkbox__input:checked + .checkbox__checkmark {
    background-color: var(--eden-secondary-color);
  }

  .checkbox__input:checked + .checkbox__checkmark::before,
  .checkbox__input:checked + .checkbox__checkmark::after {
    background-color: var(--eden-grey-000);
  }
`;
export default styles;
