var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenCheckbox_onChange;
import template from "./eden-checkbox.template.js";
import styles from "./eden-checkbox.styles.js";
class EdenCheckbox extends HTMLElement {
    constructor() {
        super();
        _EdenCheckbox_onChange.set(this, (e) => {
            const target = e.target;
            this.checked = target.checked;
            this.setAttribute("checked", String(this.checked));
        });
        this.name = this.getAttribute("name") || "";
        this.label = this.getAttribute("label") || "";
        this.checked =
            this.checked || this.getAttribute("checked") === "true" || false;
        this.disabled = this.hasAttribute("disabled");
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template({
            name: this.name,
            label: this.label,
            checked: this.checked,
        });
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
        this.checkbox = this.shadowRoot.querySelector("input");
    }
    connectedCallback() {
        this.checkbox.checked = this.checked;
        this.checkbox.addEventListener("change", __classPrivateFieldGet(this, _EdenCheckbox_onChange, "f"));
    }
    disconnectedCallback() {
        this.checkbox.removeEventListener("change", __classPrivateFieldGet(this, _EdenCheckbox_onChange, "f"));
    }
    static get observedAttributes() {
        return ["checked", "disabled"];
    }
    attributeChangedCallback(name, _, newValue) {
        if (name === "checked") {
            this.checked = newValue === "true";
            this.checkbox.checked = this.checked;
        }
        if (name === "disabled") {
            this.disabled = this.hasAttribute("disabled");
            if (this.disabled) {
                this.checkbox.setAttribute("disabled", "");
            }
            else {
                this.checkbox.removeAttribute("disabled");
            }
        }
    }
}
_EdenCheckbox_onChange = new WeakMap();
export default EdenCheckbox;
if (!customElements.get("eden-checkbox")) {
    customElements.define("eden-checkbox", EdenCheckbox);
}
