import { describe, it, expect, beforeEach, vi } from "vitest";
vi.mock("../eden-tooltip", () => ({
    default: class MockEdenTooltip {
        constructor(element, text, direction) {
            this.element = element;
            this.text = text;
            this.direction = direction;
            this.remove = vi.fn();
        }
    },
}));
describe("EdenButton Web Component", () => {
    beforeEach(async () => {
        vi.clearAllMocks();
        await import("../eden-button");
    });
    it("should extend HTMLButtonElement", async () => {
        const button = document.createElement("button", {
            is: "eden-button",
        });
        expect(button).toBeInstanceOf(HTMLButtonElement);
    });
    it("should initialize with disabled attribute", () => {
        const button = document.createElement("button", {
            is: "eden-button",
        });
        button.setAttribute("disabled", "true");
        expect(button.hasAttribute("disabled")).toBe(true);
    });
    it("should not be disabled when disabled=false", () => {
        const button = document.createElement("button", {
            is: "eden-button",
        });
        button.setAttribute("disabled", "false");
        expect(button.getAttribute("disabled")).toBe("false");
    });
    it("should create button without errors", () => {
        expect(() => {
            const button = document.createElement("button", { is: "eden-button" });
            document.body.appendChild(button);
            document.body.removeChild(button);
        }).not.toThrow();
    });
    it("should handle tooltip attribute", () => {
        const button = document.createElement("button", {
            is: "eden-button",
        });
        button.setAttribute("tooltip", "Test tooltip");
        button.setAttribute("direction", "top");
        expect(button.getAttribute("tooltip")).toBe("Test tooltip");
        expect(button.getAttribute("direction")).toBe("top");
    });
    it("should support common button attributes", () => {
        const button = document.createElement("button", {
            is: "eden-button",
        });
        button.type = "submit";
        button.name = "submit-button";
        button.value = "Submit";
        expect(button.type).toBe("submit");
        expect(button.name).toBe("submit-button");
        expect(button.value).toBe("Submit");
    });
});
