import css from "../../services/css.js";
const styles = css `
  :host {
    position: absolute;
    display: flex;
    align-items: center;
    gap: 4px;
    padding: 6px;
    font-family: var(--eden-content-font);
    color: var(--eden-grey-600);
    font-size: 13px;
    line-height: 1;
    white-space: nowrap;
    background-color: var(--eden-grey-000);
    border: 1px solid var(--eden-grey-200);
    border-radius: var(--eden-radius-200);
    box-shadow: var(--eden-shadow-100);
    transition: top 60ms var(--eden-transition-easing),
      left 60ms var(--eden-transition-easing);
    animation: eden-text-helper-appearance 320ms var(--eden-transition-easing);
    z-index: 101; /* Higher than section:has(eden-block-ui) in eden-styles.ts */
  }

  @keyframes eden-text-helper-appearance {
    0% {
      opacity: 0;
    }
  }

  :host([error]) {
    color: var(--eden-red-400);
  }

  .information {
    position: relative;
    width: 20px;
    height: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: currentcolor;
    padding: 0;
    background-color: transparent;
    border: 0;
    border-radius: 50%;
    cursor: default;
  }

  .information-icon {
    width: 16px;
    height: 16px;
    fill: currentcolor;
  }
`;
export default styles;
