import css from "../../services/css.js";
const styles = css `
  :host {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    z-index: 999;
  }

  .overlay {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background: transparent;
    border: 2px solid var(--player-color, var(--eden-primary-500));
    border-radius: var(--eden-radius-200);
    pointer-events: auto;
    cursor: not-allowed;
  }

  .player-name {
    position: absolute;
    left: 10px;
    bottom: 100%;
    padding: 2px 6px;
    font-family: var(--eden-content-font);
    font-size: 14px;
    font-weight: 500;
    color: var(--eden-grey-500);
    background-color: var(--player-color, var(--eden-grey-200));
    border-radius: var(--eden-radius-200) var(--eden-radius-200) 0 0;
  }
`;
export default styles;
