var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenPlayerSelectionIndicator_instances, _EdenPlayerSelectionIndicator_render;
import html from "../../services/html.js";
import t from "../../i18n/index.js";
import styles from "./eden-player-selection-indicator.styles.js";
class EdenPlayerSelectionIndicator extends HTMLElement {
    constructor({ clientId, firstName, lastName, zoneId, blockId }) {
        super();
        _EdenPlayerSelectionIndicator_instances.add(this);
        this.playerIndicator = null;
        this.clientId = clientId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.zoneId = zoneId;
        this.blockId = blockId;
        this.attachShadow({ mode: "open" });
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    connectedCallback() {
        this.setAttribute("data-client-id", this.clientId);
        this.setAttribute("data-zone-id", String(this.zoneId));
        this.setAttribute("data-block-id", String(this.blockId));
        __classPrivateFieldGet(this, _EdenPlayerSelectionIndicator_instances, "m", _EdenPlayerSelectionIndicator_render).call(this);
        this.playerIndicator = document.querySelector(`eden-player-indicator[data-client-id="${this.clientId}"]`);
        if (this.playerIndicator) {
            this.playerIndicator.setAttribute("hidden", "");
        }
    }
    disconnectedCallback() {
        if (this.playerIndicator) {
            this.playerIndicator.removeAttribute("hidden");
        }
    }
}
_EdenPlayerSelectionIndicator_instances = new WeakSet(), _EdenPlayerSelectionIndicator_render = function _EdenPlayerSelectionIndicator_render() {
    const playerName = `${this.firstName} ${this.lastName}`;
    this.shadowRoot.innerHTML = html `
      <button
        is="eden-button"
        class="overlay"
        tooltip="${t("ui.block.selection.locked-by")}"
      >
        <div class="player-name">${playerName}</div>
      </button>
    `;
};
export default EdenPlayerSelectionIndicator;
if (!customElements.get("eden-player-selection-indicator")) {
    customElements.define("eden-player-selection-indicator", EdenPlayerSelectionIndicator);
}
