import css from "../../services/css.js";
const styles = css `
  :host {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    align-items: center;
    font-family: var(--eden-content-font);
    font-weight: 400;
    color: var(--eden-grey-500);
    user-select: none;
    will-change: transform;
    animation: info-ui-appearance 160ms var(--eden-transition-easing);
    z-index: 3;
  }

  @keyframes info-ui-appearance {
    0% {
      opacity: 0;
      transform: scale(0.98);
    }
  }

  .info-ui__container {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
  }

  .info-ui__container::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: var(--eden-grey-000);
    opacity: 0;
    border-radius: var(--eden-radius-300);
    transition: opacity 160ms var(--eden-transition-easing);
  }

  :host(:hover) .info-ui__container::before {
    opacity: 15%;
  }

  .info-ui__dates {
    display: flex;
    flex-direction: column;
    align-items: flex-start;
    margin: 6px 0;
    padding: 16px;
    box-sizing: border-box;
    color: var(--eden-grey-500);
    background-color: var(--eden-grey-000);
    border-radius: var(--eden-radius-200);
    box-shadow: var(--eden-shadow-200);
    z-index: 4;
  }

  .info-ui__dates-title {
    margin-bottom: 4px;
    box-sizing: border-box;
    color: var(--eden-yellow-500);
    font-size: 16px;
    font-weight: 700;
    border-radius: var(--eden-radius-200);
  }

  .info-ui__period {
    padding: 2px 0;
  }

  .info-ui__period-date {
    font-size: 18px;
    font-weight: 700;
  }

  .info-ui__hidden,
  .info-ui__indexable,
  .info-ui__msem-preset {
    margin: 6px;
    padding: 10px 20px;
    background-color: var(--eden-grey-000);
    font-weight: 700;
    border-radius: var(--eden-radius-200);
    box-shadow: var(--eden-shadow-200);
    z-index: 4;
  }

  .info-ui__hidden {
    color: var(--eden-red-400);
  }
`;
export default styles;
