import template from "./eden-info-ui.template.js";
import styles from "./eden-info-ui.styles.js";
export default class EdenInfoUi extends HTMLElement {
    constructor(block, dates, hidden) {
        super();
        this.selectedDates = dates && JSON.parse(dates);
        const dateRanges = this.selectedDates
            ? buildDateRange(this.selectedDates)
            : undefined;
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template(dateRanges, hidden);
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
}
if (!customElements.get("eden-info-ui")) {
    customElements.define("eden-info-ui", EdenInfoUi);
}
const formatOptions = {
    year: "numeric",
    month: "long",
    day: "numeric",
    hour: "numeric",
    minute: "numeric",
};
function buildDateRange(dates) {
    return dates.map(([start, end]) => {
        const formatedStart = new Date(start).toLocaleDateString("fr-FR", formatOptions);
        const formatedEnd = new Date(end).toLocaleDateString("fr-FR", formatOptions);
        return {
            start: formatedStart,
            end: formatedEnd,
        };
    });
}
