import html from "../../services/html.js";
export default function template(mode, sprite, currentId, basePath) {
    return renderIcons(mode, sprite, currentId, basePath);
}
function renderIcons(mode, sprite, currentId, basePath) {
    if (mode === "sprite") {
        const icons = Array.from(sprite.querySelectorAll("symbol"));
        return icons
            .map((icon) => {
            const { id, innerHTML } = icon;
            const viewBox = icon.getAttribute("viewBox");
            const className = "#".concat(id) === currentId ? "icon icon--current" : "icon";
            const svg = Object.assign(document.createElement("button"), {
                id,
                className,
                innerHTML: html `<svg viewBox="${viewBox}">${innerHTML}</svg>`,
            });
            return svg.outerHTML;
        })
            .join("");
    }
    if (mode === "index") {
        return sprite
            .map((item) => {
            const path = `${basePath}/${item}.svg#icon`;
            const className = currentId === item ? "icon icon--current" : "icon";
            const svg = Object.assign(document.createElement("button"), {
                id: item,
                className,
                innerHTML: html `<svg><use href="${path}" /></svg>`,
            });
            return svg.outerHTML;
        })
            .join("");
    }
    return "";
}
