import html from "../../services/html.js";
import t from "../../i18n/index.js";
export default function template() {
    return html `
    <div class="ranges"></div>
    <div class="titles">
      <div class="title">${t("ui.dates-selector.from")}</div>
      <div class="title">${t("ui.dates-selector.to")}</div>
    </div>
    <button class="add-range" is="eden-button">
      <eden-icon code="plus" class="add-range__icon"></eden-icon> ${t("ui.dates-selector.add-date-range")}
    </button>
  `;
}
export function rangeTemplate() {
    const newRange = Object.assign(document.createElement("div"), {
        className: "range",
        innerHTML: html `
      <eden-input name="range-start" type="datetime-local"></eden-input>
      <eden-input name="range-end" type="datetime-local"></eden-input>
      <button
        class="remove-range"
        is="eden-button"
        tooltip="${t("ui.dates-selector.remove-date-range")}"
      >
        <eden-icon code="close" class="remove-range__icon"></eden-icon>
      </button>
    `,
    });
    return newRange;
}
