import css from "../../services/css.js";
const styles = css `
  :host {
    display: flex;
    flex-direction: column;
    gap: 6px;
  }

  .titles {
    order: -1;
    display: flex;
    gap: 6px;
    padding-right: 40px;
  }

  .ranges:empty + .titles {
    display: none;
  }

  .title {
    flex: 1 1 100%;
    padding: 0 6px;
    font-weight: 700;
  }

  .ranges {
    display: flex;
    flex-direction: column;
    gap: 14px;
  }

  .range {
    display: flex;
    align-items: center;
    gap: 6px;
    animation: dates-range-appearance 240ms var(--eden-transition-easing);
  }

  @keyframes dates-range-appearance {
    0% {
      transform: translateX(-10px);
      opacity: 0;
    }
  }

  .remove-range {
    width: 34px;
    height: 34px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--eden-grey-600);
    background-color: transparent;
    border-radius: var(--eden-radius-200);
    border: 0;
    cursor: pointer;
    box-shadow: 0 0 0 1px transparent inset;
    z-index: 1;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .remove-range:hover {
    background-color: var(--eden-grey-100);
  }

  .remove-range:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .remove-range:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .remove-range__icon {
    width: 18px;
    height: 18px;
    fill: currentcolor;
  }

  .add-range {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    margin-top: 8px;
    padding: 7px 10px;
    font-size: 15px;
    text-decoration: none;
    font-weight: 700;
    color: var(--eden-grey-000);
    background-color: var(--eden-primary-color);
    font-family: inherit;
    border: 0;
    border-radius: var(--eden-radius-200);
    box-shadow: 0 0 0 1px transparent inset;
    user-select: none;
    cursor: pointer;
    z-index: 1;
    transition: background-color 160ms var(--eden-transition-easing),
      box-shadow 160ms var(--eden-transition-easing);
  }

  .add-range:active {
    box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
  }

  .add-range:focus-visible {
    outline: 2px solid var(--eden-secondary-color);
    outline-offset: 3px;
  }

  .add-range__icon {
    flex: 0 0 22px;
    width: 22px;
    height: 22px;
    fill: currentcolor;
  }
`;
export default styles;
