import EdenDropdown from "../common/eden-dropdown.js";
import type Block from "../../core/block.js";
import type Zone from "../../core/zone.js";
import type { ActionsGroup, Variant } from "../../types.js";
interface Callbacks {
    addBefore: (code: string, variant?: string) => Promise<void>;
    addAfter: (code: string, variant?: string) => Promise<void>;
    remove: () => void;
    copy: () => Promise<void>;
    cut: () => Promise<void>;
    copyZone: () => Promise<void>;
    copyDates: () => Promise<void>;
    pasteBefore: () => Promise<void>;
    pasteAfter: () => Promise<void>;
    moveBefore: () => void;
    moveAfter: () => void;
    duplicate: () => void;
    selectDates: () => void;
    settings: () => void;
    updateVariant: (variant?: string) => void;
}
export default class EdenBlockUi extends HTMLElement {
    #private;
    block: Block;
    zone?: Zone;
    canSelectDate: boolean;
    obsolete?: boolean;
    callbacks: Callbacks;
    templates?: string[];
    maxBlocks?: number;
    disabledActions: string[];
    variant?: string;
    variants?: Variant[];
    isAdmin: boolean;
    isSuperAdmin: boolean;
    hidePaste: boolean;
    shadowRoot: ShadowRoot;
    copyDropdown: EdenDropdown | null;
    variantsDropdown: EdenDropdown | null;
    addBeforeButton: HTMLButtonElement;
    addAfterButton: HTMLButtonElement;
    moveBeforeButton: HTMLButtonElement;
    moveAfterButton: HTMLButtonElement;
    selectWeeksButton: HTMLButtonElement;
    duplicateButton: HTMLButtonElement;
    copyButton: HTMLButtonElement;
    deleteButton: HTMLButtonElement;
    settingsButton: HTMLButtonElement;
    obsoleteInfoButton: HTMLButtonElement;
    obsoleteRemoveButton: HTMLButtonElement;
    constructor(block: Block, callbacks: Callbacks, disabledActions: string[], templates?: string[], maxBlocks?: number, obsolete?: boolean, variant?: string, variants?: Variant[]);
    addToolbars: (toolbars: ActionsGroup[]) => void;
    removeActions: (toolbars: ActionsGroup[]) => void;
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
}
export {};
//# sourceMappingURL=eden-block-ui.d.ts.map