import library from "./user-interface/icons/library";
import type Block from "./core/block";
import type Brick from "./core/brick";
import type EdenToolbar from "./user-interface/block/eden-toolbar";
export declare enum EdenMode {
    connected = "connected",
    editing = "editing",
    info = "info"
}
type ActionFn = (e: MouseEvent) => void | Promise<void>;
export interface ActionObject {
    icon?: keyof typeof library;
    property?: string;
    formatter?: (option: DropdownOption) => string;
    current?: boolean;
    disabled?: boolean;
    name: string;
    action: ActionFn;
    value?: string;
}
export interface DropdownOption {
    icon?: keyof typeof library;
    dot?: boolean;
    text: string;
    formatter?: (option: DropdownOption) => string;
    onClick?: ActionFn;
    current?: boolean;
    disabled?: boolean;
    separator?: "before" | "after";
    property?: string;
    value?: string;
}
type BrickAction = ActionFn | ActionObject[];
export interface Action {
    icon: keyof typeof library;
    action: BrickAction;
    code?: RichTextCommand;
    tooltip?: string;
    dropdown?: boolean;
    command?: string;
}
export interface BrickConstructor {
    block: Block;
    element: HTMLElement;
    parentBricks: Brick[];
    options?: MarkupOptions;
    markup?: string;
    isCreation?: boolean;
    rows?: {
        name: string;
        markup: string;
    }[];
    templates?: RecursiveItem[];
}
export interface ActionsGroup {
    ui?: EdenToolbar;
    toolbar: Action[];
    watchSelectionChange?: boolean;
}
type $Schema = string | undefined;
type $Fragments = Record<string, Markup> | undefined;
export interface BareTemplates {
    $schema?: $Schema;
    $fragments?: $Fragments;
    [templateName: string]: TemplateDefinition | $Schema | $Fragments;
}
export interface FormattedTemplates {
    [templateName: string]: TemplateDefinition;
}
export interface GroupedTemplates {
    [groupName: string]: GroupedTemplateDefinition[];
}
export type GroupedTemplateDefinition = {
    code: string;
} & TemplateDefinition;
export interface TemplateDefinition {
    name: string;
    group?: TemplateGroup;
    groups?: TemplateGroup[];
    description?: string;
    unique?: boolean;
    preview?: boolean;
    cssClass?: string;
    defaultVariantName?: string;
    variants?: Variant[];
    attributes?: Attribute[];
    markup: Markup;
}
export interface Variant {
    name: string;
    cssClass: string;
}
export interface Attribute {
    name: string;
    property: string;
    placeholder?: string;
    value?: string;
    options?: string[];
    allowMultipleOptions?: boolean;
    helper?: string;
}
export type TemplateGroup = "Colonne de droite" | "Textes" | "Boutons & liens" | "Images" | "Images & Vidéos" | "Bandeaux" | "Bandeaux et entêtes" | "Mises en avant" | "Offres produits" | "Tableaux" | "Textes & images" | "Multimedia" | "Vidéos" | "Cartes" | "Templates avancés" | "Divers" | "Utilitaires" | "Espaces et séparateur" | "Pied de page";
export type Markup = MarkupObject | string | TableOptions | Markup[];
export interface MarkupObject {
    type?: MarkupType;
    markup?: Markup;
    $ref?: string;
    options?: MarkupOptions;
    [key: string]: unknown;
}
type MarkupType = "Text" | "RichText" | "Picture" | "Link" | "Icon" | "Slideshow" | "Table" | "Video" | "Iframe" | "GoogleMaps" | "YoutubePlaylist" | "Spotify" | "Recursive";
type MarkupOptions = TextOptions & RichTextOptions & PictureOptions & LinkOptions & RecursiveOptions;
export interface TextOptions {
    textLength?: {
        max: number;
        force?: boolean;
    };
}
export interface RichTextOptions extends TextOptions {
    commands?: RichTextCommand[];
    allowHtmlEdit?: boolean;
}
export type RichTextCommand = "bold" | "italic" | "list" | "orderedList" | "left" | "center" | "right" | "justify" | "indent" | "outdent" | "link" | "unlink" | "cleanup" | "color" | "background" | "family" | "size" | "weight" | "source";
export interface PictureOptions {
    sizes?: Record<string, {
        src: string;
        width?: number;
        height?: number;
    }>;
}
export interface LinkOptions {
    defaultHref?: string;
    defaultTitle?: string;
    defaultTarget?: "_blank" | "_self" | "_parent" | "_top";
}
export interface RecursiveItem {
    name: string;
    id: string;
    markup: Markup;
}
export interface RecursiveOptions {
    templates?: RecursiveItem[];
}
export interface TableOption {
    name: string;
    markup: string;
}
interface TableOptions {
    markup?: TableOption[];
}
interface FileManagerItemCommonProps {
    name: string;
    path: string;
}
export interface FileManagerFile extends FileManagerItemCommonProps {
    kind: "file";
    extension: string;
    thumb: string;
    metadata: {
        width: number;
        height: number;
        size: string;
    };
}
interface FileManagerDirectory extends FileManagerItemCommonProps {
    kind: "directory";
}
export type FileManagerItem = FileManagerFile | FileManagerDirectory;
export interface FileManagerList {
    allowControls?: boolean;
    breadcrumb?: FileManagerBreadcrumbItem[];
    files?: FileManagerItem[];
}
export interface FileManagerBreadcrumbItem {
    name: string;
    path: string;
}
export interface FileManagerStorage {
    used: number;
    max: number;
    ratio: number;
}
export interface StructureTreeNode {
    id: number;
    name: string;
    path: string;
    template: string | null;
    subs?: StructureTreeNode[];
    mountedSource?: string | null;
}
export interface StructureTree {
    currentNode: number;
    structure: StructureTreeNode[];
}
export interface StructureLayout {
    name: string;
    view: string;
}
export interface StructurePagesMetadata {
    type: "text" | "checkbox" | "select";
    code: string;
    label: string;
    helper?: string;
    options?: string[];
    allowMultipleOptions?: boolean;
}
interface StructureGlobalEntryData {
    id: number;
    name?: string;
    virtualPage: string;
    active: boolean;
    highlight: boolean;
    metadata: Record<string, any>;
}
interface StructureLocalizedEntry {
    disabled?: boolean;
    label?: string;
    shortLabel?: string;
    subTitle?: string;
    path?: string;
    seo?: {
        title?: string;
        keywords?: string;
        description?: string;
        robots?: string;
        canonical?: string;
        inSitemap?: boolean;
        frequency?: string;
        priority?: number;
    };
}
interface StructureLocalizedEntryData {
    [key: string]: StructureLocalizedEntry;
}
export type StructureEntryData = StructureGlobalEntryData & StructureLocalizedEntryData;
export interface StructureNode {
    id: number;
    name: string;
    label?: string;
    template: string | null;
    disabled?: boolean;
    path?: string;
    subs?: StructureTree[];
    mountedSource?: string | null;
}
type Role = "eden_editor" | "eden_admin";
export interface User {
    email: string;
    firstName: string;
    lastName: string;
    iat: number;
    id: number;
    roles: Role[];
}
export interface Path {
    lang: string;
    path: string;
}
export type NodeActionSave = StructureEntryData;
export interface NodeActionCreate {
    name: string;
    parentId: number;
    position: number;
    tmpId: number;
}
export interface NodeActionRename {
    navItemId: number;
    newName: string;
}
export interface NodeActionMove {
    navItemId: number;
    parentId: number;
    position: number;
}
export interface NodeActionRemove {
    navItemId: number;
}
export type NodeAction = NodeActionSave | NodeActionCreate | NodeActionRename | NodeActionMove | NodeActionRemove;
export interface Player {
    clientId: string;
    firstName: string;
    lastName: string;
    position: number;
    path: string;
}
export {};
//# sourceMappingURL=types.d.ts.map