export default function blockSelected(block) {
    if (window.Eden.socket?.readyState !== WebSocket.OPEN ||
        window.Eden.players.length === 0 ||
        !block.zone) {
        return;
    }
    const pathname = window.location.pathname;
    const zoneId = window.Eden.zones.indexOf(block.zone);
    const blockId = block.zone.blocks?.indexOf(block);
    if (zoneId === -1 || blockId === -1)
        return;
    window.Eden.socket.send(JSON.stringify({
        clientId: window.Eden.clientId,
        type: "block-selected",
        firstName: window.Eden.user.firstName,
        lastName: window.Eden.user.lastName,
        blockId,
        zoneId,
        path: pathname,
    }));
}
