function getOffset(el) {
    let x = 0;
    let y = 0;
    while (el && !isNaN(el.offsetLeft) && !isNaN(el.offsetTop)) {
        x += el.offsetLeft - el.scrollLeft;
        y += el.offsetTop - el.scrollTop;
        el = el.offsetParent;
    }
    return { x, y };
}
export function smoothScrollTo(element) {
    const { y } = getOffset(element);
    const top = y - window.innerHeight / 4;
    window.scroll({ top, behavior: "smooth" });
}
export function isLocalhost() {
    return window.location.hostname === "localhost";
}
export function disableBrowserTranslation() {
    document.documentElement.setAttribute("translate", "no");
    document.documentElement.classList.add("notranslate");
}
