export function parseUrl(url) {
    if (url.startsWith("http")) {
        const parser = document.createElement("a");
        parser.href = url;
        const searchObject = parser.search
            .replace(/^\?/, "")
            .split("&")
            .filter((query) => query !== "")
            .reduce((acc, query) => {
            const [key, value] = query.split("=");
            return { ...acc, [key]: value };
        }, {});
        return {
            url,
            protocol: parser.protocol,
            host: parser.host,
            hostname: parser.hostname,
            port: parser.port,
            path: parser.pathname,
            search: parser.search,
            hash: parser.hash,
            searchObject,
        };
    }
}
export function buildParams(params = {}, exclusions) {
    const defaultParams = { rel: "0" };
    const allParams = { ...defaultParams, ...params };
    return Object.keys(allParams)
        .filter((key) => !exclusions.includes(key))
        .map((key, i) => {
        const param = allParams[key];
        if (!param)
            return "";
        const sign = i === 0 ? "?" : "&";
        return `${sign}${key}=${param}`;
    })
        .join("");
}
