const defaultTag = "div";
const fragmentFasterHeuristic = /[-+,> ]/;
const selectorParse = /(?:\s*([-+ ,<>]))?\s*(\.|!\.?|#)?([-\w$]+)?(?:\[([^\]=]+)=?['"]?([^\]'"]*)['"]?\])?/g;
const insertTextNode = (element, text) => {
    element.appendChild(document.createTextNode(text));
};
const isElement = (node) => {
    return node !== null && node.nodeType === Node.ELEMENT_NODE;
};
const isHTMLElement = (node) => {
    return isElement(node) && node instanceof HTMLElement;
};
const isRecord = (obj) => {
    return typeof obj === "object" && !obj.nodeType;
};
export const put = (topReferenceElement, ...args) => {
    let fragment = null;
    let returnValue = null;
    let lastSelectorArg = false;
    let nextSibling = null;
    let referenceElement = topReferenceElement;
    let current = null;
    let topRef = topReferenceElement;
    const insertLastElement = (argument) => {
        if (current && referenceElement && current !== referenceElement) {
            let container = referenceElement;
            if (referenceElement === topRef) {
                if (!fragment && fragmentFasterHeuristic.test(argument)) {
                    fragment = document.createDocumentFragment();
                }
                if (fragment) {
                    container = fragment;
                }
            }
            if (isElement(container)) {
                container.insertBefore(current, nextSibling);
            }
            else {
                container.insertBefore(current, nextSibling);
            }
        }
    };
    args.forEach((argument, i) => {
        if (typeof argument === "object") {
            lastSelectorArg = false;
            if (isElement(argument)) {
                current = argument;
                insertLastElement("");
                referenceElement = current;
                nextSibling = null;
            }
            else if (isRecord(argument)) {
                Object.entries(argument).forEach(([key, value]) => {
                    if (current) {
                        current.setAttribute(key, value);
                    }
                });
            }
        }
        else if (lastSelectorArg) {
            lastSelectorArg = false;
            if (current) {
                insertTextNode(current, argument);
            }
        }
        else {
            if (i === 0) {
                topRef = null;
            }
            lastSelectorArg = true;
            const leftoverCharacters = argument.replace(selectorParse, (_t, combinator, prefix, value, attrName, attrValue) => {
                if (combinator) {
                    insertLastElement(argument);
                    if (combinator === "-" || combinator === "+") {
                        const parentNode = (current || referenceElement).parentNode;
                        if (isElement(parentNode)) {
                            referenceElement = parentNode;
                        }
                        nextSibling = current || referenceElement;
                        if (isElement(nextSibling)) {
                            nextSibling = nextSibling;
                        }
                        current = null;
                        if (combinator === "+") {
                            if (nextSibling) {
                                nextSibling = nextSibling.nextSibling;
                            }
                        }
                    }
                    else if (combinator === "<") {
                        const parent = (current || referenceElement).parentNode;
                        if (isElement(parent)) {
                            referenceElement = parent;
                            current = parent;
                        }
                    }
                    else {
                        if (combinator === ",") {
                            referenceElement = topRef || topReferenceElement;
                        }
                        else if (current) {
                            referenceElement = current;
                        }
                        current = null;
                        nextSibling = null;
                    }
                    if (current)
                        referenceElement = current;
                }
                let tag = !prefix && value ? value : null;
                if (tag || (!current && (prefix || attrName))) {
                    if (tag === "$") {
                        if (referenceElement && isElement(referenceElement)) {
                            insertTextNode(referenceElement, String(args[++i]));
                        }
                    }
                    else {
                        tag = tag || defaultTag;
                        current = document.createElement(tag);
                    }
                }
                if (prefix) {
                    if (value === "$") {
                        value = String(args[++i]);
                    }
                    if (current) {
                        if (prefix === "#") {
                            current.id = value || "";
                        }
                        else {
                            let currentClassName = current.className || "";
                            let removed = currentClassName &&
                                (" " + currentClassName + " ").replace(" " + value + " ", " ");
                            if (prefix === ".") {
                                current.className = currentClassName
                                    ? (removed + value).substring(1)
                                    : value || "";
                            }
                            else {
                                if (argument === "!") {
                                    const putResult = put(document.createElement("div"), current, "<");
                                    if (putResult &&
                                        isHTMLElement(putResult) &&
                                        putResult.innerHTML !== undefined) {
                                        putResult.innerHTML = "";
                                    }
                                }
                                else {
                                    removed = removed.substring(1, removed.length - 1);
                                    if (removed !== currentClassName) {
                                        current.className = removed;
                                    }
                                }
                            }
                        }
                    }
                }
                if (attrName) {
                    if (attrValue === "$") {
                        attrValue = String(args[++i]);
                    }
                    if (current) {
                        if (attrName === "style") {
                            if (isHTMLElement(current)) {
                                current.style.cssText = attrValue || "";
                            }
                        }
                        else {
                            const action = attrName.charAt(0) === "!"
                                ? (attrName = attrName.substring(1)) && "removeAttribute"
                                : "setAttribute";
                            if (action === "removeAttribute") {
                                current.removeAttribute(attrName);
                            }
                            else {
                                current.setAttribute(attrName, attrValue === "" ? attrName : attrValue || "");
                            }
                        }
                    }
                }
                return "";
            });
            if (leftoverCharacters) {
                throw new SyntaxError(`Unexpected char ${leftoverCharacters} in ${argument}`);
            }
            insertLastElement(argument);
            if (current) {
                referenceElement = current;
                returnValue = current;
            }
            else if (isElement(referenceElement)) {
                returnValue = referenceElement;
            }
        }
    });
    if (topRef && fragment) {
        topRef.appendChild(fragment);
    }
    return returnValue;
};
