import html from "./html.js";
const userAgent = window.navigator.userAgent;
const isMac = /Macintosh|Mac|Mac OS|MacIntel|MacPPC|Mac68K/gi.test(userAgent);
export function generateShortcut(...keys) {
    const shortcut = keys
        .map((key) => {
        let result = key;
        if (key === "backspace")
            result = "⌫";
        if (key === "enter")
            result = "↵";
        if (key === "shift")
            result = "⇧";
        if (key === "ctrl" && isMac)
            result = "⌘";
        return html `<span class='key'>${result}</span>`;
    })
        .join("");
    return html `<span class='shortcut'>${shortcut}</span>`;
}
