import { snackbar } from "../user-interface/common/eden-snackbar";
import { htmlStringToElements } from "./html";
import { isLocalhost } from "./util";
import t from "../i18n";
export function copyToClipboard(textContent) {
    const textarea = Object.assign(document.createElement("textarea"), {
        textContent,
        readOnly: true,
        style: "position: absolute; left: -9999px;",
    });
    document.body.appendChild(textarea);
    textarea.select();
    document.execCommand("copy");
    document.body.removeChild(textarea);
}
export async function isContentNotValidForPaste(zone) {
    if (!zone) {
        return true;
    }
    try {
        const { maxBlocks, templates } = zone;
        const { childElementCount } = zone.element;
        const clipboardContent = await navigator.clipboard.readText();
        if (!clipboardContent.startsWith("fromEden:")) {
            return true;
        }
        if (!maxBlocks && !templates) {
            return false;
        }
        const elements = Array.from(htmlStringToElements(clipboardContent.replace("fromEden:", "")));
        return ((!!maxBlocks && elements.length + childElementCount > maxBlocks) ||
            (!!templates &&
                elements.some((elem) => !templates.includes(elem.dataset.template || ""))));
    }
    catch (e) {
        if (isLocalhost()) {
            console.info("Reading from clipboard error", e);
        }
        snackbar(t("snackbars.clipboard-access-denied"), "error");
        return true;
    }
}
