export async function checkDuplicateEntry(innerLeft, code, parentId) {
    const nodes = Array.from(innerLeft.querySelectorAll("eden-structure-tree-node"));
    const parentNode = nodes.find((node) => node.nodeId === parentId);
    const parentTree = parentNode &&
        parentNode.querySelector("eden-structure-tree");
    const subs = parentTree && Array.from(parentTree.children);
    const message = subs?.some((sub) => sub.name === code) && code;
    return message;
}
export function noTrailingSlash(value = "") {
    const isRelative = value.length >= 2 && value[0] === "/" && value[1] !== "/";
    const isEmpty = value.trim() === "";
    const isRoot = value === "/";
    return !isRelative || isEmpty || isRoot;
}
