import { fetchContentSave, fetchRevalidate, fetchNodeUpdate, fetchNodeCreation, fetchNodeMove, fetchNodeRename, fetchNodeRemoval, sendRevalidateAllBeacon, fetchLastUpdated, fetchFileManagerList, createFileManagerFolder, removeFileManagerItem, renameFileManagerItem, rotateFileManagerImage, moveFileManagerItem, cropFileManagerItem, fileManagerMoveList, uploadFileManagerItem, fetchFileManagerStorageStats, fetchTimestamp, } from "./fetcher.js";
import { cleanupZone } from "./cleanup.js";
import t from "../i18n/index.js";
const actions = {
    saveNode: fetchNodeUpdate,
    create: fetchNodeCreation,
    move: fetchNodeMove,
    rename: fetchNodeRename,
    remove: fetchNodeRemoval,
};
export async function saveNavContent(action, node) {
    const result = await actions[action](node);
    window.sessionStorage.setItem("eden_revalidation_needed", "true");
    return result;
}
export async function saveZones({ lang, path, startedAt, ignoreFixedZones = false, }) {
    try {
        const zoneElements = Array.from(document.querySelectorAll("[data-eden-zone]"));
        const hasFixedZones = zoneElements.some((element) => element.getAttribute("data-eden-fixed-content") === "true" &&
            element.hasAttribute("data-eden-modified"));
        const zones = zoneElements
            .map((element) => {
            const content = cleanupZone(element.innerHTML);
            return {
                code: element.getAttribute("data-eden-zone"),
                content,
                fixed: element.getAttribute("data-eden-fixed-content") === "true",
            };
        })
            .filter((zone) => (ignoreFixedZones ? !zone.fixed : true));
        const { error } = await fetchContentSave(lang, path, zones, startedAt);
        if (error) {
            return { error };
        }
        if (hasFixedZones) {
            sendRevalidateAllBeacon(lang);
            zoneElements.forEach((element) => element.removeAttribute("data-eden-modified"));
        }
        fetchRevalidate(lang, path);
        return { status: "ok" };
    }
    catch (e) {
        console.error(e);
        return { error: t("error.save-retry") };
    }
}
export async function checkLastUpdated(path) {
    const { lang, langPrefix } = window.EdenConfig;
    try {
        return fetchLastUpdated(lang, langPrefix, path);
    }
    catch {
        console.error(t("console.last-updated-check-error"));
        return {};
    }
}
export async function getTimestamp() {
    return fetchTimestamp();
}
export async function getFilesList(path) {
    return fetchFileManagerList(path);
}
export async function getFilesStorageStats() {
    return fetchFileManagerStorageStats();
}
export async function createFolder(name, path) {
    return createFileManagerFolder(name, path);
}
export async function removeItem(path, paths) {
    return removeFileManagerItem(path, paths);
}
export async function renameItem(file, name) {
    return renameFileManagerItem(file, name);
}
export async function cropItem(path, left, top, width, height, targetWidth, targetHeight, only) {
    return cropFileManagerItem(path, left, top, width, height, targetWidth, targetHeight, only);
}
export async function moveList(paths) {
    return fileManagerMoveList(paths);
}
export async function moveItem(path, paths, target) {
    return moveFileManagerItem(path, paths, target);
}
export async function rotateImage(path) {
    return rotateFileManagerImage(path);
}
export async function uploadItem(payload) {
    return uploadFileManagerItem(payload);
}
