import { describe, it, expect } from "vitest";
import typeOf from "../type-of";
describe("typeOf Service", () => {
    it("should return 'string' for string values", () => {
        expect(typeOf("hello")).toBe("string");
        expect(typeOf("")).toBe("string");
        expect(typeOf("123")).toBe("string");
    });
    it("should return 'number' for number values", () => {
        expect(typeOf(123)).toBe("number");
        expect(typeOf(0)).toBe("number");
        expect(typeOf(-456)).toBe("number");
        expect(typeOf(3.14)).toBe("number");
    });
    it("should return 'boolean' for boolean values", () => {
        expect(typeOf(true)).toBe("boolean");
        expect(typeOf(false)).toBe("boolean");
    });
    it("should return 'array' for array values", () => {
        expect(typeOf([])).toBe("array");
        expect(typeOf([1, 2, 3])).toBe("array");
        expect(typeOf(["a", "b"])).toBe("array");
        expect(typeOf([{ key: "value" }])).toBe("array");
    });
    it("should return 'object' for object values", () => {
        expect(typeOf({})).toBe("object");
        expect(typeOf({ key: "value" })).toBe("object");
        expect(typeOf({ a: 1, b: 2 })).toBe("object");
    });
    it("should return 'object' for null", () => {
        expect(typeOf(null)).toBe("object");
    });
    it("should return 'undefined' for undefined", () => {
        expect(typeOf(undefined)).toBe("undefined");
    });
    it("should return 'function' for functions", () => {
        expect(typeOf(() => { })).toBe("function");
        expect(typeOf(function test() { })).toBe("function");
    });
    it("should handle Date objects", () => {
        expect(typeOf(new Date())).toBe("object");
    });
    it("should handle RegExp objects", () => {
        expect(typeOf(/test/)).toBe("object");
    });
    it("should handle Set objects", () => {
        expect(typeOf(new Set())).toBe("object");
    });
    it("should handle Map objects", () => {
        expect(typeOf(new Map())).toBe("object");
    });
});
